/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.util.swing.DateTimePicker;

public class DateTimeSelector
extends JPanel {
    private LocalDateTime dateTime;
    private LocalDateTime min;
    private LocalDateTime max;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd  HH:mm:ss");
    private final JTextField field;
    private final JButton button;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public DateTimeSelector() {
        this.setLayout(new BorderLayout());
        this.field = new JTextField();
        this.add((Component)this.field, "Center");
        this.field.setEditable(false);
        FontMetrics fm = this.field.getFontMetrics(this.field.getFont());
        float widthInColumns = (float)fm.stringWidth(" 0000-00-00  00:00:00 ") / (float)fm.charWidth('m');
        this.field.setColumns(Math.round(widthInColumns) + 2);
        this.button = new JButton("...");
        this.add((Component)this.button, "East");
        this.button.addActionListener(e -> {
            LocalDateTime dt = DateTimePicker.selectDateTime(this.dateTime, null, this.button);
            if (dt != null) {
                this.set(dt);
                this.fire();
            }
        });
        this.set(null);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void set(LocalDateTime value) {
        if (value == null || this.min != null && this.min.isAfter(value) || this.max != null && this.max.isBefore(value)) {
            this.dateTime = null;
            this.field.setText("");
        } else {
            this.dateTime = value;
            this.field.setText(" " + this.formatter.format(this.dateTime) + " ");
        }
    }

    public LocalDateTime get() {
        return this.dateTime;
    }

    public void setValidRange(LocalDateTime start, LocalDateTime end) {
        this.min = start;
        this.max = end;
        if (this.dateTime != null && (this.min != null && this.min.isAfter(this.dateTime) || this.max != null && this.max.isBefore(this.dateTime))) {
            this.dateTime = null;
            this.field.setText("");
        }
    }

    public void setFormat(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern);
        if (this.dateTime != null) {
            this.field.setText(this.formatter.format(this.dateTime));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.field.setToolTipText(text);
        this.button.setToolTipText(text);
    }

    public void addListener(Listener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fire() {
        this.listeners.forEach(listener -> listener.changed(this));
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("JDateTimeChooser Test");
            frame.setDefaultCloseOperation(3);
            DateTimeSelector chooser = new DateTimeSelector();
            chooser.setValidRange(LocalDateTime.now().minusMonths(1L), LocalDateTime.now().plusMonths(2L));
            frame.add(chooser);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public static interface Listener {
        public void changed(DateTimeSelector var1);
    }
}

