/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.daq.ims.Utils;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.utilities.location.Location;

public class SourceMetaData
implements Serializable {
    private static final long serialVersionUID = 397370667275465591L;
    private final Location location;
    private final Location.LocationType sensor;
    private final byte lane;
    private final String platform;
    private final Version software;
    private final int firmware;
    private final long serialNumber;
    private final long length;
    private final int[] registerValues;

    SourceMetaData(byte sensor, byte lane, String platform, Version software, int firmware, long serialNumber, long length, byte bay, byte board, int[] registerValues) {
        this.sensor = Location.LocationType.values()[sensor - 1];
        this.lane = lane;
        this.platform = platform;
        this.software = software;
        this.firmware = firmware;
        this.serialNumber = serialNumber;
        this.length = length;
        this.location = new Location((int)bay, (int)board);
        this.registerValues = registerValues;
    }

    public Location.LocationType getSensor() {
        return this.sensor;
    }

    public byte getLane() {
        return this.lane;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Version getSoftware() {
        return this.software;
    }

    public int getFirmware() {
        return this.firmware;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public long getLength() {
        return this.length;
    }

    public Location getLocation() {
        return this.location;
    }

    public int[] getRegisterValues() {
        return this.registerValues;
    }

    public String toString() {
        return String.format("SourceMetaData{location=%s, sensor=%s, lane=%d, platform=%s, software=%s, firmware=%x, serialNumber=%x, length=%s, registerValues=%s}", this.location, this.sensor, this.lane, this.platform, this.software, this.firmware, this.serialNumber, Utils.humanReadableByteCount(this.length), Arrays.toString(this.registerValues));
    }
}

