/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AxisButtonsPanel
extends JPanel {
    private MotorCommandListener sender = null;
    private String axisName = null;
    private JToggleButton enableToggle;
    private JButton faultClearButton;
    private JButton homeButton;

    public AxisButtonsPanel() {
        this.initComponents();
        JToggleButton toggle = this.enableToggle;
        toggle.addChangeListener(event -> {
            if (toggle.isSelected()) {
                toggle.setText("DISABLED");
            } else {
                toggle.setText("ENABLED ");
            }
        });
    }

    public void init(MotorCommandListener sender) {
        this.sender = sender;
    }

    public void configure(int axisNum, PlatformConfig config) {
        this.axisName = config.getAxisNames().get(axisNum);
    }

    public void enableCommands() {
        this.faultClearButton.setEnabled(true);
        this.homeButton.setEnabled(true);
        this.enableToggle.setEnabled(true);
    }

    public void disableCommands() {
        this.faultClearButton.setEnabled(false);
        this.homeButton.setEnabled(false);
        this.enableToggle.setEnabled(false);
    }

    public void update(AxisStatus status) {
        this.enableToggle.setSelected(!status.isEnabled());
    }

    private void initComponents() {
        this.faultClearButton = new JButton();
        this.homeButton = new JButton();
        this.enableToggle = new JToggleButton();
        this.faultClearButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.faultClearButton, (String)NbBundle.getMessage(AxisButtonsPanel.class, (String)"AxisButtonsPanel.faultClearButton.text"));
        this.faultClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisButtonsPanel.this.handleClearFaults(evt);
            }
        });
        this.homeButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.homeButton, (String)NbBundle.getMessage(AxisButtonsPanel.class, (String)"AxisButtonsPanel.homeButton.text"));
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisButtonsPanel.this.handleHome(evt);
            }
        });
        this.enableToggle.setFont(new Font("DejaVu LGC Sans", 1, 13));
        this.enableToggle.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.enableToggle, (String)NbBundle.getMessage(AxisButtonsPanel.class, (String)"AxisButtonsPanel.enableToggle.text"));
        this.enableToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisButtonsPanel.this.handleEnableToggle(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.faultClearButton).addGap(18, 18, 18).addComponent(this.homeButton).addGap(18, 18, 18).addComponent(this.enableToggle).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.faultClearButton).addComponent(this.enableToggle).addComponent(this.homeButton)));
    }

    private void handleClearFaults(ActionEvent evt) {
        this.sender.clearAxisFaults(new ClearAxisFaults(this.axisName));
    }

    private void handleHome(ActionEvent evt) {
        this.sender.homeAxis(new HomeAxis(this.axisName));
    }

    private void handleEnableToggle(ActionEvent evt) {
        this.sender.changeAxisEnable(new ChangeAxisEnable(this.axisName, !this.enableToggle.isSelected()));
    }
}

