/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.daq.ims.DAQStats;

@DataAttributes(units="unitless")
public class DAQDriverStats
extends DAQStats
implements Serializable {
    @DataAttributes(description="PGP Frames Received. The total number of PGP frames received. This should equal with the rx_frames from the Firmware statistics.")
    private final long received;
    @DataAttributes(description="PGP Frame Errors. The total number of PGP frames received in error. This should equal the rx_errors from the Firmware statistics.")
    private final long errors;
    @DataAttributes(description="PGP Frames Received (channel 0). Counts the number of PGP frames received on each virtual channel.")
    private final long rx0;
    @DataAttributes(description="PGP Frames Received (channel 1). Counts the number of PGP frames received on each virtual channel.")
    private final long rx1;
    @DataAttributes(description="PGP Frames Received (channel 2). Counts the number of PGP frames received on each virtual channel.")
    private final long rx2;
    @DataAttributes(description="PGP Frames Received (channel 3). Counts the number of PGP frames received on each virtual channel.")
    private final long rx3;
    private static final long serialVersionUID = 4894440689055979272L;

    DAQDriverStats(byte bay, byte board, long received, long errors, long rx0, long rx1, long rx2, long rx3) {
        super(6, bay, board);
        this.received = received;
        this.errors = errors;
        this.rx0 = rx0;
        this.rx1 = rx1;
        this.rx2 = rx2;
        this.rx3 = rx3;
        this.statMap.put("received", received);
        this.statMap.put("errors", errors);
        this.statMap.put("rx0", rx0);
        this.statMap.put("rx1", rx1);
        this.statMap.put("rx2", rx2);
        this.statMap.put("rx3", rx3);
    }

    public long getReceived() {
        return this.received;
    }

    public long getErrors() {
        return this.errors;
    }

    public long getRx0() {
        return this.rx0;
    }

    public long getRx1() {
        return this.rx1;
    }

    public long getRx2() {
        return this.rx2;
    }

    public long getRx3() {
        return this.rx3;
    }
}

