/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import plotter.Axis;
import plotter.ColorMap;
import plotter.DefaultAxisModel;
import plotter.PlotLayout;
import plotter.RainbowColorMap;

public class ColorTest
extends JPanel {
    public ColorTest(Axis axis, ColorMap map) {
        super(new PlotLayout());
        this.add((Component)axis, "West");
        this.add((Component)new MapPainter(axis, map), "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public static void main(String[] args) {
        double[] bins = new double[11];
        for (int i = 0; i < 11; ++i) {
            bins[i] = (double)i / 10.0;
        }
        DefaultAxisModel model = new DefaultAxisModel(bins, false, false);
        Axis leftAxis = new Axis(model, Axis.AxisPosition.LEFT);
        RainbowColorMap map = new RainbowColorMap();
        JFrame frame = new JFrame("ColorTest");
        frame.getToolkit().setDynamicLayout(true);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new ColorTest(leftAxis, map));
        frame.pack();
        frame.show();
    }

    private static class MapPainter
    extends JComponent {
        private ColorMap map;
        private Axis axis;

        MapPainter(Axis axis, ColorMap map) {
            this.axis = axis;
            this.map = map;
            this.setToolTipText("");
            this.setPreferredSize(new Dimension(25, 300));
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            return this.axis.getToolTipText(me);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            double ww = size.getWidth() - (double)insets.left - (double)insets.right;
            double hh = size.getHeight() - (double)insets.top - (double)insets.bottom;
            double x1 = insets.left;
            double x2 = x1 + ww;
            double yy = insets.top - 1;
            Line2D.Double line = new Line2D.Double();
            int i = 0;
            while ((double)i < hh) {
                ((Line2D)line).setLine(x1, yy, x2, yy);
                g2.setPaint(this.map.getColor(1.0 - (double)i / hh, 1.0f));
                g2.draw(line);
                yy += 1.0;
                ++i;
            }
        }
    }
}

