/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class CompoundView
implements PersistableMonitorView {
    protected Descriptor descriptor = new Descriptor();
    private final JComponent panel;
    private PersistableAgentChannelsFilter filter;
    private final ArrayList<PersistableMonitorView> children1 = new ArrayList(0);
    private final ArrayList<PersistableMonitorView> children2 = new ArrayList(0);

    public CompoundView(JComponent panel) {
        this.panel = panel;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        if (!(filter instanceof PersistableAgentChannelsFilter)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires PersistableAgentChannelsFilter, found " + filter.getClass().getSimpleName());
        }
        this.filter = (PersistableAgentChannelsFilter)filter;
        this.children1.forEach(child -> child.setFilter(this.filter));
        this.children2.forEach(child -> child.setFilter(this.filter));
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this.filter;
    }

    public void addView(PersistableMonitorView view, Mode mode) {
        switch (mode) {
            case INDEPENDENT: {
                this.children1.add(view);
                break;
            }
            case FORWARD: {
                this.children2.add(view);
            }
        }
    }

    @Override
    public void connect(AgentStatusEvent event) {
        this.children2.forEach(view -> view.connect(event));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        this.children2.forEach(view -> view.configure(event));
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        this.children2.forEach(view -> view.statusChanged(event));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        this.children2.forEach(view -> view.disconnect(event));
    }

    @Override
    public void install() {
        if (!this.children2.isEmpty()) {
            PersistableMonitorView.super.install();
        }
        this.children1.forEach(view -> view.install());
    }

    @Override
    public void uninstall() {
        if (!this.children2.isEmpty()) {
            PersistableMonitorView.super.uninstall();
        }
        this.children1.forEach(view -> view.uninstall());
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        ArrayList<PersistableMonitorView> views = this.getChildren();
        Persistable.Descriptor[] cd = new Persistable.Descriptor[views.size()];
        for (int i = 0; i < cd.length; ++i) {
            cd[i] = ((PersistableMonitorView)views.get(i)).save();
        }
        desc.setChildren(cd);
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        ArrayList<PersistableMonitorView> vv;
        Descriptor desc;
        Persistable.Descriptor[] dd;
        if (descriptor instanceof Descriptor && (dd = (desc = (Descriptor)descriptor).getChildren()) != null && dd.length == (vv = this.getChildren()).size()) {
            for (int i = 0; i < dd.length; ++i) {
                ((PersistableMonitorView)vv.get(i)).restore(dd[i]);
            }
        }
    }

    private ArrayList<PersistableMonitorView> getChildren() {
        ArrayList<PersistableMonitorView> out = new ArrayList<PersistableMonitorView>(this.children1.size() + this.children2.size());
        out.addAll(this.children1);
        out.addAll(this.children2);
        return out;
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private Persistable.Descriptor[] children;

        public Persistable.Descriptor[] getChildren() {
            return this.children;
        }

        public void setChildren(Persistable.Descriptor[] children) {
            this.children = children;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.children != null) {
                desc.children = (Persistable.Descriptor[])desc.children.clone();
            }
            return desc;
        }
    }

    public static enum Mode {
        INDEPENDENT,
        FORWARD;

    }
}

