/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;

public class MotorCommandSender
implements MotorCommandListener,
TargetStatusListener {
    private static final Logger LOG = Logger.getLogger(MotorCommandSender.class.getName());
    private String target = "";
    private CommandSender sender = new CommandSender("");

    public void setTarget(String target) {
        this.target = target;
        this.sender = new CommandSender(target);
    }

    private void sendCommand(Serializable argObj) {
        String cmdName = new Exception().getStackTrace()[1].getMethodName();
        LOG.log(Level.INFO, "Command name is {0}", cmdName);
        this.sender.sendCommand(null, cmdName, new Object[]{argObj});
    }

    @Override
    public void changeAxisEnable(ChangeAxisEnable cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void changeOutputLine(ChangeOutputLine cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void clearAllFaults(ClearAllFaults cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void clearAxisFaults(ClearAxisFaults cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void clearCapture(ClearCapture cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void enableAllAxes(EnableAllAxes cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void homeAxis(HomeAxis cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void sendConfiguration(SendConfiguration cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void setupCapture(SetupCapture cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void stopAllMotion(StopAllMotion cmd) {
        this.sendCommand(cmd);
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        this.setTarget(evt.getTargetSubsystem());
    }
}

