/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.lsst.ccs.camera.kafka.avro.AvroSchemaMapper;
import org.lsst.ccs.camera.kafka.avro.Topic;
import org.lsst.ccs.camera.kafka.avro.TopicWithTags;

public class GenericRecordManager {
    private final AvroSchemaMapper avroSchemaMapper;
    private volatile Map<TopicWithTags, Map<Long, GenericRecord>> dataByTopics = new ConcurrentHashMap<TopicWithTags, Map<Long, GenericRecord>>();

    public GenericRecordManager(AvroSchemaMapper schemaMapper) {
        this.avroSchemaMapper = schemaMapper;
    }

    public GenericRecordManager(GenericRecordManager manager) {
        this.avroSchemaMapper = manager.avroSchemaMapper;
        this.dataByTopics.putAll(manager.dataByTopics);
    }

    public boolean addKeyValueForPath(String path, Object value, long timestamp) {
        Topic.TopicField topicField = this.avroSchemaMapper.getTopicFieldForPath(path);
        if (topicField != null) {
            TopicWithTags topicWithTags = this.avroSchemaMapper.getTopicWithTagsForPath(path);
            Map recordsMapForTopicWithTags = this.dataByTopics.computeIfAbsent(topicWithTags, t -> new ConcurrentHashMap());
            GenericRecord genericRecord = recordsMapForTopicWithTags.computeIfAbsent(timestamp, t -> this.createRecord(topicWithTags, (long)t));
            genericRecord.put(topicField.getName(), value);
            return true;
        }
        return false;
    }

    private GenericRecord createRecord(TopicWithTags tWithTags, long timestamp) {
        GenericData.Record record = new GenericData.Record(this.avroSchemaMapper.getSchemaForTopic(tWithTags.getTopic()));
        record.put("timestamp", (Object)timestamp);
        for (Map.Entry<String, String> e : tWithTags.getTagValues().entrySet()) {
            record.put(e.getKey(), (Object)e.getValue());
        }
        return record;
    }

    public List<Topic> getTopicsWithData() {
        HashSet<Topic> topicsWithDataList = new HashSet<Topic>();
        for (TopicWithTags t : this.dataByTopics.keySet()) {
            topicsWithDataList.add(t.getTopic());
        }
        return new ArrayList<Topic>(topicsWithDataList);
    }

    public List<GenericRecord> getRecordsForTopic(Topic t) {
        ArrayList<GenericRecord> listOfRecords = new ArrayList<GenericRecord>();
        for (Map.Entry<TopicWithTags, Map<Long, GenericRecord>> e : this.dataByTopics.entrySet()) {
            if (!e.getKey().getTopic().equals(t)) continue;
            listOfRecords.addAll(e.getValue().values());
        }
        return listOfRecords;
    }
}

