/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.localdb.statusdb.server.AlertEvent;
import org.lsst.ccs.localdb.statusdb.server.AlertInfo;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.Datas;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.messaging.AgentPresenceListener;

@Plugin(name="LSST Rest Service Plugin", id="rest-service", description="Plugin that handles connection to the REST server.")
public class LsstRestService
extends ConsolePlugin {
    public static final String FROM_BUS_PROPERTY = "fromBus";
    public static final String HOST_PROPERTY = "server";
    public static final String PORT_PROPERTY = "port";
    public static final String CONNECT_ON_STARTUP_PROPERTY = "connectOnStartup";
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private Client client;
    private WebTarget server;
    private boolean refreshInProgress;
    private boolean refreshRequested;
    private long lastRefresh;
    private AgentPresenceListener agentsListener;

    @Override
    public void initialize() {
        this.getServices().addProperty(FROM_BUS_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${fromBus} Use REST server found on CCS buses.");
        this.getServices().addProperty(HOST_PROPERTY, "localhost");
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Server: ${server#history=5}");
        this.getServices().addProperty(PORT_PROPERTY, 8080);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Port: ${port}");
        this.getServices().addProperty(CONNECT_ON_STARTUP_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${connectOnStartup} Connect on startup.");
    }

    @Override
    public void start() {
        if (((Boolean)this.getServices().getProperty(CONNECT_ON_STARTUP_PROPERTY)).booleanValue()) {
            this.refreshConnection(false);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        Set<String> keys = changes.keySet();
        if (keys.contains(HOST_PROPERTY) || keys.contains(PORT_PROPERTY) || keys.contains(FROM_BUS_PROPERTY)) {
            this.refreshConnection(true);
        }
    }

    public synchronized void refreshConnection(boolean queue) {
        if (this.refreshInProgress) {
            if (queue) {
                this.refreshRequested = true;
            }
        } else {
            this.refreshRequested = false;
            this.refreshInProgress = true;
            this.lastRefresh = System.currentTimeMillis();
            Thread t = new Thread(this::connect, "REST Connector");
            t.setDaemon(true);
            t.start();
        }
    }

    private void checkConnection(WebTarget servak) {
        if (servak != null) {
            try {
                servak.request().head();
            }
            catch (RuntimeException x) {
                this.refreshConnection(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        String url = null;
        WebTarget servak = null;
        try {
            url = this.getURL();
            if (url != null) {
                this.getConsole().getLogger().fine((Object)("Connecting to REST server " + url));
                servak = this.client.target(url).path("dataserver");
                servak.request().head();
                this.getConsole().getLogger().fine((Object)"REST server connection successful.");
            }
        }
        catch (RuntimeException e) {
            servak = null;
            this.getConsole().getLogger().warn((Object)("Unable to connect to REST server at " + url), (Throwable)e);
        }
        finally {
            boolean repeat = false;
            LsstRestService lsstRestService = this;
            synchronized (lsstRestService) {
                if (this.refreshRequested) {
                    repeat = true;
                    this.refreshRequested = false;
                } else {
                    this.notifyAll();
                    this.refreshInProgress = false;
                    if (this.server != servak) {
                        this.server = servak;
                        this.fireEvent();
                    }
                }
            }
            if (repeat) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURL() {
        AgentPresenceListener oldListener;
        LsstRestService lsstRestService = this;
        synchronized (lsstRestService) {
            oldListener = this.agentsListener;
            if (this.client == null) {
                this.client = ClientBuilder.newClient();
            }
        }
        if (oldListener != null) {
            this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(oldListener);
        }
        String url = null;
        if (((Boolean)this.getServices().getProperty(FROM_BUS_PROPERTY)).booleanValue()) {
            String agentName = null;
            for (AgentInfo agent : this.getConsole().getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                if (!AgentCategory.REST_SERVER.name().equals(agent.getAgentProperty("agentCategory"))) continue;
                String host = agent.getAgentProperty("rest-service-addr");
                String port = agent.getAgentProperty("rest-service-port");
                String entryPoint = agent.getAgentProperty("rest-service-entrypoint");
                url = String.format("http://%s:%d%s", host, Integer.valueOf(port), entryPoint);
                agentName = agent.getName();
                break;
            }
            LsstRestService lsstRestService2 = this;
            synchronized (lsstRestService2) {
                this.agentsListener = agentName == null ? new AgentConnectListener() : new AgentDisconnectListener(agentName);
            }
            this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.agentsListener);
        } else {
            String host = null;
            try {
                host = this.getServices().getProperty(HOST_PROPERTY).toString();
                int port = (Integer)this.getServices().getProperty(PORT_PROPERTY);
                url = String.format("http://%s:%d/rest/data", host, port);
            }
            catch (RuntimeException x) {
                this.getConsole().getLogger().warn((Object)("Invalid server " + host + " or port " + this.getServices().getProperty(PORT_PROPERTY)));
                throw x;
            }
        }
        return url;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void fireEvent() {
        SwingUtilities.invokeLater(() -> {
            ChangeEvent event = new ChangeEvent(this);
            this.listeners.forEach(listener -> listener.stateChanged(event));
        });
    }

    public DataChannel.DataChannelList getTrendingList(long begin) {
        this.getConsole().getLogger().fine((Object)("REST service: retrieving the list of trending data channels for the last " + begin + " seconds."));
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("listchannels");
            if (begin > 0L) {
                resource = resource.queryParam("maxIdleSeconds", new Object[]{String.valueOf(begin)});
            }
            return (DataChannel.DataChannelList)resource.request(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
    }

    public DataChannel.DataChannelList getStateList(long begin) {
        this.getConsole().getLogger().fine((Object)("REST service: retrieving the list of trending state channels for the last " + begin + " seconds."));
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("liststates");
            if (begin > 0L) {
                resource = resource.queryParam("maxIdleSeconds", new Object[]{String.valueOf(begin)});
            }
            return (DataChannel.DataChannelList)resource.request(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
    }

    public AlertInfo.AlertInfoList getAlertList(long begin) {
        this.getConsole().getLogger().fine((Object)("REST service: retrieving the list of trending alert channels for the last " + begin + " seconds."));
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        try {
            resource = resource.path("listalerts");
            if (begin > 0L) {
                resource = resource.queryParam("maxIdleSeconds", new Object[]{String.valueOf(begin)});
            }
            return (AlertInfo.AlertInfoList)resource.request(new String[]{"text/xml"}).get(AlertInfo.AlertInfoList.class);
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            return null;
        }
    }

    public StateInfo.StateInfoList getStateInfo(String agent) {
        WebTarget resource = this.getServer(true);
        if (resource == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        try {
            resource = resource.path("statesinfo").path(agent);
            StateInfo.StateInfoList out = (StateInfo.StateInfoList)resource.request(new String[]{"text/xml"}).get(StateInfo.StateInfoList.class);
            this.getConsole().getLogger().fine((Object)("REST service: retrieved state values for " + agent + " in " + (System.currentTimeMillis() - time) / 1000L + " seconds."));
            return out;
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve state values for " + agent + " after " + (System.currentTimeMillis() - time) / 1000L + " seconds."));
            return null;
        }
    }

    public TrendingResult[] getTrendingData(long begin, long end, String flavor, int nBins, String ... paths) {
        WebTarget resource = this.getServer(false);
        if (resource == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        try {
            resource = resource.path("data/search");
            resource = resource.queryParam("t1", new Object[]{String.valueOf(begin)}).queryParam("t2", new Object[]{String.valueOf(end)});
            if (flavor != null) {
                resource = resource.queryParam("flavor", new Object[]{flavor});
            }
            if (nBins > 0) {
                resource = resource.queryParam("n", new Object[]{Integer.toString(nBins)});
            }
            for (String path : paths) {
                resource = resource.queryParam("path", new Object[]{path});
            }
            Invocation.Builder a = resource.request(new String[]{"text/xml"});
            Datas datas = (Datas)a.get(Datas.class);
            Data[] dd = datas.getDataArray();
            if (dd.length != paths.length) {
                return null;
            }
            TrendingResult[] out = new TrendingResult[dd.length];
            for (int i = 0; i < dd.length; ++i) {
                out[i] = dd[i] == null ? null : dd[i].getTrendingResult();
            }
            if (this.getConsole().getLogger().isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("REST service: Retrieved trending data for:\n");
                for (String path : paths) {
                    sb.append(path).append("\n");
                }
                sb.append("From ").append(begin).append(" to ").append(end).append(" (").append((end - begin) / 1000L).append(" seconds).");
                sb.append(" Flavor: ").append(flavor).append(", bins: ").append(nBins).append(".");
                this.getConsole().getLogger().fine((Object)sb.toString());
            }
            return out;
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve trending data after " + (System.currentTimeMillis() - time) / 1000L + " seconds: " + x));
            return null;
        }
        catch (RuntimeException x) {
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve trending data after " + (System.currentTimeMillis() - time) / 1000L + " seconds: " + x));
            return null;
        }
    }

    public List<StateChange> getStateTransitions(long begin, long end, String agent, Collection<String> components, Collection<String> states) {
        WebTarget resource = this.getServer(false);
        if (resource == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        try {
            resource = resource.path("statechanges/" + agent);
            resource = resource.queryParam("t1", new Object[]{String.valueOf(begin)}).queryParam("t2", new Object[]{String.valueOf(end)});
            if (components != null) {
                for (String c2 : components) {
                    resource = resource.queryParam("component", new Object[]{c2});
                }
            }
            if (states != null) {
                for (String s2 : states) {
                    resource = resource.queryParam("state", new Object[]{s2});
                }
            }
            Invocation.Builder a = resource.request(new String[]{"text/xml"});
            List out = ((StateChange.StateChangesList)a.get(StateChange.StateChangesList.class)).list;
            if (this.getConsole().getLogger().isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("REST service: Retrieved state transitions for ").append(agent).append(":");
                if (states != null && !states.isEmpty() && !states.iterator().next().equals(" ")) {
                    sb.append("\nStates: ");
                    states.forEach(s -> sb.append((String)s).append(","));
                }
                if (components != null && !components.isEmpty() && !components.iterator().next().equals(" ")) {
                    sb.append("\nComponents: ");
                    components.forEach(c -> sb.append((String)c).append(","));
                }
                sb.append("\nFrom ").append(begin).append(" to ").append(end).append(" (").append((end - begin) / 1000L).append(" seconds).");
                this.getConsole().getLogger().fine((Object)sb.toString());
            }
            return out;
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve state transitions after " + (System.currentTimeMillis() - time) / 1000L + " seconds: " + x));
            return null;
        }
        catch (RuntimeException x) {
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve state transitions after " + (System.currentTimeMillis() - time) / 1000L + " seconds: " + x));
            return null;
        }
    }

    public List<AlertEvent> geAlerts(long begin, long end, String ... ids) {
        WebTarget resource = this.getServer(false);
        if (resource == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        try {
            resource = resource.path("alerthistory");
            resource = resource.queryParam("t1", new Object[]{String.valueOf(begin)}).queryParam("t2", new Object[]{String.valueOf(end)});
            for (String id : ids) {
                resource = resource.queryParam("id", new Object[]{id});
            }
            Invocation.Builder a = resource.request(new String[]{"text/xml"});
            List<AlertEvent> out = ((AlertEvent.AlertEventList)a.get(AlertEvent.AlertEventList.class)).list;
            if (this.getConsole().getLogger().isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("REST service: Retrieved alerts for: ");
                for (String id : ids) {
                    sb.append(id).append(",");
                }
                sb.deleteCharAt(sb.length() - 1).append(".");
                sb.append("\nFrom ").append(begin).append(" to ").append(end).append(" (").append((end - begin) / 1000L).append(" seconds).");
                this.getConsole().getLogger().fine((Object)sb.toString());
            }
            if (out == null) {
                out = Collections.emptyList();
            }
            return out;
        }
        catch (ProcessingException | WebApplicationException x) {
            this.checkConnection(resource);
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve alerts after " + (System.currentTimeMillis() - time) / 1000L + " seconds: " + x));
            return null;
        }
        catch (RuntimeException x) {
            this.getConsole().getLogger().fine((Object)("REST service: failed to retrieve alerts after " + (System.currentTimeMillis() - time) / 1000L + " seconds: " + x));
            return null;
        }
    }

    private synchronized WebTarget getServer(boolean retry) {
        while (this.refreshInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException x) {
                return null;
            }
        }
        if (this.server == null && (retry || System.currentTimeMillis() - this.lastRefresh > 300000L)) {
            this.refreshConnection(true);
            return this.getServer(false);
        }
        return this.server;
    }

    private class AgentConnectListener
    implements AgentPresenceListener {
        private AgentConnectListener() {
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo agent : agents) {
                if (!AgentCategory.REST_SERVER.name().equals(agent.getAgentProperty("agentCategory"))) continue;
                LsstRestService.this.refreshConnection(true);
            }
        }
    }

    private class AgentDisconnectListener
    implements AgentPresenceListener {
        private final String agent;

        AgentDisconnectListener(String agent) {
            this.agent = agent;
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo agentInfo : agents) {
                if (!agentInfo.getName().equals(this.agent)) continue;
                LsstRestService.this.refreshConnection(true);
                break;
            }
        }
    }
}

