/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import jas.hist.DataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.ManagedAxis;
import jas.hist.XYDataSource;
import jas.plot.AxisType;
import jas.plot.DateAxis;
import jas.plot.StringAxisY;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.freehep.jas.plugin.plotter.DefaultPlotter;
import org.freehep.jas.plugin.plotter.DefaultRegion;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.plotter.JAS3Plot;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Meta;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataType;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public final class TrendPlotter
implements Plotter,
Persistable {
    public static String CATEGORY = "TrendPlotter";
    private Descriptor descriptor;
    public static final String NO_META = "no-meta";
    private static final Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.CYAN, Color.DARK_GRAY, Color.LIGHT_GRAY};
    private final LsstTrendingPlugin plugin = Console.getConsole().getSingleton(LsstTrendingPlugin.class);
    private final DefaultPlotter plotter;
    private final ArrayList<TrendInfo> trends = new ArrayList(1);
    private PlotRegion region;
    private TimeWindow timeWindow;
    private DataType dataType;
    private TimeWindow oldTimeWindow;
    private Meta metaOnPoint;
    private EnumSet<Meta> metaOffPoint;
    private boolean isCustomRangeT;
    private boolean isCustomRangeV;
    private double[] rangeT;
    private double[] rangeV;
    private boolean ignoreMeta;
    private int nStringTrends;
    private TrendInfo focusedStringTrendInfo;
    private static final HashSet<String> NEED_CALIB = new HashSet<String>(Arrays.asList("alert", "state", "boolean", "string"));

    public TrendPlotter() {
        this.descriptor = new Descriptor();
        this.reset();
        try {
            this.plotter = (DefaultPlotter)this.plugin.getPlotFactory().createPlotterFor(JAS3DataSource.class);
            this.plotter.getPlot().setShowStatistics(false);
            this.plotter.getPlot().getXAxis().setRangeAutomatic(false);
            this.plotter.getPlot().getYAxis().setRangeAutomatic(false);
            this.plotter.getPlot().addMouseListener((MouseListener)new TimeZoom());
        }
        catch (ClassCastException x) {
            throw new RuntimeException("TrendPlotter is designed to wrap DefaultPlotter", x);
        }
    }

    public PlotRegion getRegion() {
        return this.region;
    }

    public void setRegion(PlotRegion region) {
        this.region = region;
        try {
            DefaultRegion dr = (DefaultRegion)region;
            dr.addPopupItems((HasPopupItems)new Popup());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public EnumSet<Meta> getMeta() {
        EnumSet<Meta> out = this.metaOnPoint == null ? EnumSet.noneOf(Meta.class) : EnumSet.of(this.metaOnPoint);
        out.addAll(this.metaOffPoint);
        return out;
    }

    public void setMeta(EnumSet<Meta> extras) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean isActive() {
        if (this.region != null) {
            try {
                return ((JComponent)this.viewable()).getTopLevelAncestor() != null;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public List<Trend> getTrends() {
        return this.trends.stream().map(info -> info.trend).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.trends.isEmpty();
    }

    public synchronized void setDataType(DataType type) {
        this.dataType = type;
        this.descriptor.setDataType(type.toCompressedString());
    }

    public synchronized DataType getDataType() {
        return this.dataType;
    }

    public synchronized void setTimeWindow(TimeWindow timeWindow) {
        this.timeWindow = timeWindow;
        this.descriptor.setTimeWindow(timeWindow.toCompressedString());
    }

    public synchronized TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public void plot(Object timeHistory, int mode) {
        this.plot(timeHistory, mode, null, null);
    }

    public void plot(List<Trend> trendList, int mode) {
        if (trendList.size() == 1) {
            this.plot(trendList.get(0), mode);
        } else {
            trendList.forEach(trend -> this.plot(trend, 1, null, NO_META));
        }
    }

    public void plot(Object timeHistory, int mode, Object style, String options) {
        if (!(timeHistory instanceof Trend) || mode != 0 && mode != 1) {
            return;
        }
        Set<Object> opt = options == null || options.trim().isEmpty() ? Collections.emptySet() : new HashSet<String>(Arrays.asList(options.split("\\s*,\\s*")));
        if (mode == 0) {
            this.clear();
        } else {
            this.checkRange();
            if (!this.trends.isEmpty() && this.trends.get(0).hasOffPoint()) {
                this.clearPlotter(true);
                this.trends.get(0).removeOffPoint();
                this.plotter.plot((Object)this.trends.get((int)0).data.get(0), 1);
            }
        }
        Trend trend = (Trend)timeHistory;
        trend.setPlotter(this);
        TrendInfo trendInfo = new TrendInfo(trend);
        int trendIndex = this.trends.size();
        this.trends.add(trendInfo);
        Jas3Source ds = new Jas3Source(trendIndex, this.metaOnPoint, null);
        trendInfo.data.add(ds);
        if (!this.metaOffPoint.isEmpty() && this.trends.size() == 1 && !opt.contains(NO_META)) {
            for (Meta meta : this.metaOffPoint) {
                for (String key : meta.getKeys()) {
                    ds = new Jas3Source(trendIndex, meta, key);
                    trendInfo.data.add(ds);
                }
            }
        }
        this.plotter.plot((Object)trendInfo.data.get(0), 1);
        for (int i = 1; i < trendInfo.data.size(); ++i) {
            this.plotter.plot((Object)trendInfo.data.get(i), 1);
        }
    }

    public void remove(Object data) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.clearData();
        this.reset();
        this.clearPlotter(false);
    }

    public Component viewable() {
        return this.plotter.viewable();
    }

    public List<Object> getData() {
        ArrayList<Object> out = new ArrayList<Object>(this.trends.size());
        this.trends.forEach(info -> out.add(info.trend));
        return out;
    }

    public void toFront() {
        PlotPage page;
        if (this.region != null && (page = this.region.getPage()) != null) {
            page.setCurrentRegion(this.region);
            page.showPage();
        }
    }

    void onRefreshRequest(Trend trend) {
        for (TrendInfo info : this.trends) {
            if (info.trend != trend) continue;
            info.messageID = this.plugin.getConsole().setStatusMessage("Loading trending data...", 0);
            break;
        }
    }

    void onDataChange(Trend trend) {
        TrendInfo trendInfo = null;
        for (TrendInfo info : this.trends) {
            if (info.trend != trend) continue;
            trendInfo = info;
            break;
        }
        if (trendInfo != null) {
            trendInfo.data.forEach(ds -> ((Jas3Source)ds).update());
            this.plugin.getConsole().setStatusMessage(null, trendInfo.messageID);
            this.setPlotProperties();
            trendInfo.data.forEach(ds -> ((Jas3Source)ds).replot());
        }
    }

    private void replot() {
        if (this.trends.size() > 1) {
            this.trends.forEach(info -> info.data.get(0).update());
            this.setPlotProperties();
            this.trends.forEach(info -> info.data.get(0).replot());
        } else if (this.trends.size() == 1) {
            Trend trend = this.trends.get((int)0).trend;
            this.clearData();
            this.clearPlotter(true);
            this.plot(trend, 1);
        }
    }

    private void clearData() {
        this.trends.forEach(info -> info.trend.setPlotter(null));
        this.trends.clear();
    }

    private void reset() {
        TrendingPreferences pref = this.plugin.getPreferences();
        this.metaOnPoint = null;
        this.metaOffPoint = EnumSet.noneOf(Meta.class);
        pref.getDrawMeta().forEach(m -> {
            if (m.isOnPoint()) {
                this.metaOnPoint = m;
            } else {
                this.metaOffPoint.add((Meta)((Object)m));
            }
        });
        this.ignoreMeta = pref.isIgnoreMetaRange();
        this.isCustomRangeT = false;
        this.isCustomRangeV = false;
        this.rangeT = null;
        this.rangeV = null;
    }

    private void setPlotProperties() {
        JASHistAxis axis = this.plotter.getPlot().getXAxis();
        axis.setRangeAutomatic(false);
        double[] r = new double[]{axis.getMin(), axis.getMax()};
        if (this.isCustomRangeT) {
            if (!this.isRangeEqual(this.rangeT, r)) {
                axis.setRange(this.rangeT[0], this.rangeT[1]);
            }
        } else {
            long begin = Long.MAX_VALUE;
            long end = 0L;
            for (TrendInfo trendInfo : this.trends) {
                Trend trend = trendInfo.trend;
                long[] range = trend.getTimeRange();
                if (range[0] < begin) {
                    begin = range[0];
                }
                if (range[1] <= end) continue;
                end = range[1];
            }
            if (end < begin) {
                end = begin = System.currentTimeMillis();
            }
            if (end == begin) {
                begin -= 1000L;
                end += 1000L;
            }
            this.rangeT = new double[]{(double)begin / 1000.0, (double)end / 1000.0};
            axis.setRange(this.rangeT[0], this.rangeT[1]);
        }
        axis = this.plotter.getPlot().getYAxis();
        String units = this.getUnits();
        if (units != null) {
            axis.setLabel(units);
        }
        r = new double[]{axis.getMin(), axis.getMax()};
        if (!this.isCustomRangeV) {
            if (this.rangeV == null || axis.getRangeAutomatic() || this.isRangeEqual(this.rangeV, r)) {
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (TrendInfo info : this.trends) {
                    List<Jas3Source> data;
                    if (!"double".equals(info.trend.getType()) || (data = info.data).isEmpty()) continue;
                    if (this.ignoreMeta) {
                        double[] range = data.get(0).getValueRange();
                        if (range[0] < min) {
                            min = range[0];
                        }
                        if (!(range[1] > max)) continue;
                        max = range[1];
                        continue;
                    }
                    for (Jas3Source dataset : data) {
                        double[] range = dataset.getValueRange();
                        if (range[0] < min) {
                            min = range[0];
                        }
                        if (!(range[1] > max)) continue;
                        max = range[1];
                    }
                }
                if (max < min) {
                    min = 0.0;
                    max = 1.0;
                } else if (min == max) {
                    if (min < 0.0) {
                        min *= 2.0;
                        max = 0.0;
                    } else if (min > 0.0) {
                        min = 0.0;
                        max *= 2.0;
                    } else {
                        min = -1.0;
                        max = 1.0;
                    }
                } else {
                    double d = (max - min) * 0.05;
                    min -= d;
                    max += d;
                }
                this.rangeV = new double[]{min, max};
            } else {
                this.isCustomRangeV = true;
                this.rangeV = r;
            }
        }
        double max = 2.0;
        this.nStringTrends = 0;
        for (TrendInfo info : this.trends) {
            if (!this.needsCalibration(info.trend)) continue;
            ++this.nStringTrends;
            int n = info.trend.getData().getNames().length;
            if ((double)n > max) {
                max = n;
            }
            if (this.focusedStringTrendInfo != null) continue;
            this.focusedStringTrendInfo = info;
        }
        if (this.nStringTrends > 0) {
            double padding = (this.rangeV[1] - this.rangeV[0]) * 0.05;
            double d = this.rangeV[0] + padding;
            double step = (this.rangeV[1] - this.rangeV[0] - 2.0 * padding) / max;
            double shift = step / (double)this.nStringTrends;
            int i = 0;
            for (TrendInfo info : this.trends) {
                List<Jas3Source> data;
                if (!this.needsCalibration(info.trend) || (data = info.data).isEmpty()) continue;
                data.get(0).calibrate(d + (double)i++ * shift, step);
            }
        }
        axis.setRange(this.rangeV[0], this.rangeV[1]);
        if (this.trends.size() == 1) {
            this.plotter.getPlot().setTitle(this.trends.get((int)0).trend.getDescriptor().getTitle());
        }
        if (this.nStringTrends > 0) {
            this.setStringAxis();
        }
    }

    private boolean needsCalibration(Trend trend) {
        return trend.getData() != null && NEED_CALIB.contains(trend.getType());
    }

    private void checkRange() {
        double[] r;
        JASHistAxis a;
        if (!this.isCustomRangeT && this.rangeT != null) {
            a = this.plotter.getPlot().getXAxis();
            r = new double[]{a.getMin(), a.getMax()};
            if (!a.getRangeAutomatic() && !this.isRangeEqual(r, this.rangeT)) {
                this.isCustomRangeT = true;
                this.rangeT = r;
            }
        }
        if (!this.isCustomRangeV && this.rangeV != null) {
            a = this.plotter.getPlot().getYAxis();
            r = new double[]{a.getMin(), a.getMax()};
            if (!a.getRangeAutomatic() && !this.isRangeEqual(r, this.rangeV)) {
                this.isCustomRangeV = true;
                this.rangeV = r;
            }
        }
    }

    private boolean isRangeEqual(double[] r1, double[] r2) {
        double tolerance = (r1[1] - r1[0]) / 10.0;
        return Math.abs(r1[0] - r2[0]) < tolerance && Math.abs(r1[1] - r2[1]) < tolerance;
    }

    private void clearPlotter(boolean keepProperties) {
        JAS3Plot plot = this.plotter.getPlot();
        if (keepProperties) {
            String title = plot.getTitle();
            JASHistAxis a = plot.getXAxis();
            double tMin = a.getMin();
            double tMax = a.getMax();
            a = plot.getYAxis();
            double vMin = a.getMin();
            double vMax = a.getMax();
            this.plotter.clear();
            if (title != null && !title.equals(plot.getTitle())) {
                plot.setTitle(title);
            }
            if (tMin != (a = plot.getXAxis()).getMin() || tMax != a.getMax()) {
                a.setRange(tMin, tMax);
            }
            if (vMin != (a = plot.getYAxis()).getMin() || vMax != a.getMax()) {
                a.setRange(vMin, vMax);
            }
        } else {
            this.plotter.clear();
        }
        plot.setShowStatistics(false);
        plot.getXAxis().setRangeAutomatic(false);
        plot.getYAxis().setRangeAutomatic(false);
    }

    private String getUnits() {
        String out = null;
        for (TrendInfo info : this.trends) {
            TrendData d;
            if (info.trend == null || (d = info.trend.getData()) == null) continue;
            String u = d.getSingleValueMetadata(AgentChannel.Key.UNITS);
            if (u == null) {
                return null;
            }
            if (out == null) {
                out = u;
                continue;
            }
            if (out.equals(u)) continue;
            return null;
        }
        return out;
    }

    private void setStringAxis() {
        StringAxisY stringAxis;
        List stringInfos = this.trends.stream().filter(info -> this.needsCalibration(info.trend)).collect(Collectors.toList());
        if (stringInfos.isEmpty()) {
            return;
        }
        JAS3Plot plot = this.plotter.getPlot();
        ManagedAxis a = (ManagedAxis)plot.getYAxis(1);
        a.setRangeAutomatic(false);
        try {
            stringAxis = (StringAxisY)a.getType();
        }
        catch (ClassCastException x) {
            stringAxis = new StringAxisY();
            a.setType((AxisType)stringAxis);
        }
        JASHistAxis leftAxis = plot.getYAxis();
        double min = leftAxis.getMin();
        double max = leftAxis.getMax();
        int n = 0;
        for (TrendInfo info2 : stringInfos) {
            n += info2.trend.getData().getNames().length;
        }
        String[] labels = new String[n];
        double[] values = new double[n];
        Color[] colors = new Color[n];
        int i = 0;
        for (TrendInfo info3 : stringInfos) {
            Color color;
            Object s;
            JASHistData hd = plot.getHandle((DataSource)info3.data.get(0));
            try {
                s = hd.getStyle();
                color = ((JASHist1DHistogramStyle)s).getLineColor();
            }
            catch (ClassCastException | NullPointerException x) {
                color = Color.BLACK;
            }
            s = info3.data.get(0);
            String[] names = info3.trend.getData().getNames();
            int k = 0;
            for (k = 0; k < names.length; ++k) {
                labels[i] = names[k];
                values[i] = ((Jas3Source)s).base + (double)k * ((Jas3Source)s).step;
                colors[i++] = color;
            }
        }
        stringAxis.setLabels(labels, values, colors, min, max);
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor();
        if (!this.trends.isEmpty()) {
            int n = this.trends.size();
            Trend.Descriptor[] tds = new Trend.Descriptor[n];
            for (int i = 0; i < n; ++i) {
                tds[i] = this.trends.get((int)i).trend.save();
            }
            desc.setTrends(tds);
        }
        if (this.timeWindow != null) {
            desc.setTimeWindow(this.timeWindow.toCompressedString());
        }
        if (this.dataType != null) {
            desc.setDataType(this.dataType.toCompressedString());
        }
        if (this.metaOnPoint != null) {
            desc.setOnPointMeta(this.metaOnPoint.name());
        }
        if (!this.metaOffPoint.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.metaOffPoint.forEach(m -> sb.append(m.name()).append("+"));
            desc.setOffPointMeta(sb.substring(0, sb.length() - 1));
        }
        desc.setCustomRangeT(this.isCustomRangeT);
        desc.setRangeT(this.isCustomRangeT ? Arrays.copyOf(this.rangeT, this.rangeT.length) : null);
        desc.setCustomRangeV(this.isCustomRangeV);
        desc.setRangeV(this.isCustomRangeV ? Arrays.copyOf(this.rangeV, this.rangeV.length) : null);
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor d) {
        String s;
        this.descriptor = ((Descriptor)d).clone();
        this.isCustomRangeT = this.descriptor.isCustomRangeT();
        this.rangeT = this.descriptor.getRangeT();
        this.isCustomRangeV = this.descriptor.isCustomRangeV();
        this.rangeV = this.descriptor.getRangeV();
        String ms = this.descriptor.getOnPointMeta();
        if (ms != null) {
            this.metaOnPoint = Meta.valueOf(ms);
        }
        ms = this.descriptor.getOffPointMeta();
        this.metaOffPoint = EnumSet.noneOf(Meta.class);
        if (ms != null) {
            String[] ss;
            for (String s2 : ss = ms.split("\\+")) {
                this.metaOffPoint.add(Meta.valueOf(s2));
            }
        }
        this.timeWindow = (s = this.descriptor.getTimeWindow()) == null ? this.plugin.getSelectedTimeWindow() : TimeWindow.parseCompressedString(s);
        s = this.descriptor.getDataType();
        this.dataType = s == null ? this.plugin.getSelectedDataType() : DataType.parseCompressedString(s);
        Trend.Descriptor[] tds = this.descriptor.getTrends();
        if (tds != null) {
            ArrayList<Trend> trendList = new ArrayList<Trend>(tds.length);
            for (Trend.Descriptor td : tds) {
                Trend trend = new Trend(td);
                trendList.add(trend);
            }
            if (!trendList.isEmpty()) {
                this.plot(trendList, 0);
                this.plugin.refresh(this);
                this.toFront();
            }
        }
    }

    static /* synthetic */ double[] access$1702(TrendPlotter x0, double[] x1) {
        x0.rangeT = x1;
        return x1;
    }

    static /* synthetic */ double[] access$1902(TrendPlotter x0, double[] x1) {
        x0.rangeV = x1;
        return x1;
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private Trend.Descriptor[] trends;
        private String timeWindow;
        private String dataType;
        private String onPointMeta;
        private String offPointMeta;
        private double[] rangeT;
        private double[] rangeV;
        private boolean customRangeT;
        private boolean customRangeV;

        @Override
        public String getCategory() {
            return CATEGORY;
        }

        @Override
        public void setCategory(String category) {
        }

        public boolean isCustomRangeV() {
            return this.customRangeV;
        }

        public void setCustomRangeV(boolean customRangeV) {
            this.customRangeV = customRangeV;
        }

        public boolean isCustomRangeT() {
            return this.customRangeT;
        }

        public void setCustomRangeT(boolean customRangeT) {
            this.customRangeT = customRangeT;
        }

        public double[] getRangeV() {
            return this.rangeV;
        }

        public void setRangeV(double[] rangeV) {
            this.rangeV = rangeV;
        }

        public double[] getRangeT() {
            return this.rangeT;
        }

        public void setRangeT(double[] rangeT) {
            this.rangeT = rangeT;
        }

        public String getOffPointMeta() {
            return this.offPointMeta;
        }

        public void setOffPointMeta(String offPointMeta) {
            this.offPointMeta = offPointMeta;
        }

        public String getOnPointMeta() {
            return this.onPointMeta;
        }

        public void setOnPointMeta(String onPointMeta) {
            this.onPointMeta = onPointMeta;
        }

        public String getTimeWindow() {
            return this.timeWindow;
        }

        public void setTimeWindow(String timeWindow) {
            this.timeWindow = timeWindow;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public Trend.Descriptor[] getTrends() {
            return this.trends;
        }

        public void setTrends(Trend.Descriptor[] trends) {
            this.trends = trends;
        }

        @Override
        public Descriptor clone() {
            Descriptor clone = (Descriptor)super.clone();
            if (this.trends != null) {
                int n = this.trends.length;
                clone.trends = new Trend.Descriptor[n];
                for (int i = 0; i < n; ++i) {
                    clone.trends[i] = this.trends[i].clone();
                }
            }
            if (this.rangeT != null) {
                clone.rangeT = Arrays.copyOf(this.rangeT, 2);
            }
            if (this.rangeV != null) {
                clone.rangeV = Arrays.copyOf(this.rangeV, 2);
            }
            return clone;
        }
    }

    private class TimeZoom
    extends MouseAdapter {
        private long dragStartTime;
        private long time0;
        private long time1;

        private TimeZoom() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                this.time0 = this.getTime(e);
                this.dragStartTime = System.currentTimeMillis();
                this.time1 = 0L;
            }
            catch (RuntimeException x) {
                this.dragStartTime = 0L;
                this.time0 = 0L;
                this.time1 = 0L;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                this.time1 = this.getTime(e);
                long dragTime = System.currentTimeMillis() - this.dragStartTime;
                if (dragTime > 500L && dragTime < 15000L && Math.abs(this.time1 - this.time0) > 60000L) {
                    if (this.time1 < this.time0) {
                        long t = this.time0;
                        this.time0 = this.time1;
                        this.time1 = t;
                    }
                    TimeWindow tw = new TimeWindow("", this.time0 / 1000L, this.time1 / 1000L, false);
                    SwingUtilities.invokeLater(() -> {
                        if (TrendPlotter.this.oldTimeWindow == null) {
                            TrendPlotter.this.oldTimeWindow = TrendPlotter.this.timeWindow;
                        }
                        TrendPlotter.this.plugin.refresh(TrendPlotter.this, tw, null);
                    });
                    return;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.dragStartTime = 0L;
            this.time0 = 0L;
            this.time1 = 0L;
        }

        private long getTime(MouseEvent e) {
            int mod = e.getModifiersEx();
            if (mod != 1024 && mod != 0) {
                throw new RuntimeException();
            }
            ManagedAxis xAxis = (ManagedAxis)TrendPlotter.this.plotter.getPlot().getXAxis();
            DateAxis dateAxis = (DateAxis)xAxis.getType();
            MouseEvent axisEvent = SwingUtilities.convertMouseEvent((Component)TrendPlotter.this.plotter.getPlot(), e, (Component)xAxis);
            long timeMin = dateAxis.getAxisMin();
            long timeMax = dateAxis.getAxisMax();
            long time = dateAxis.map((double)axisEvent.getX());
            if (time < timeMin || time > timeMax) {
                throw new RuntimeException();
            }
            ManagedAxis yAxis = (ManagedAxis)TrendPlotter.this.plotter.getPlot().getYAxis();
            axisEvent = SwingUtilities.convertMouseEvent((Component)TrendPlotter.this.plotter.getPlot(), e, (Component)yAxis);
            int iY = axisEvent.getY();
            if (iY < 0 || iY > yAxis.getSize().height) {
                throw new RuntimeException();
            }
            return time;
        }
    }

    private class Popup
    implements HasPopupItems {
        private Popup() {
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component componentt, Point point) {
            Component[] components = menu.getComponents();
            int n = components.length;
            for (int i = 0; i < n; ++i) {
                Component c = components[i];
                if (!(c instanceof JMenuItem) || !"Copy Plot...".equals(((JMenuItem)c).getText())) continue;
                menu.remove(i);
                AbstractAction act = new AbstractAction("Save Plot..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PersistenceService service = TrendPlotter.this.plugin.getConsole().getSingleton(PersistenceService.class);
                        service.saveAs(TrendPlotter.this.save(), "Save trending plot configuration", null);
                    }
                };
                menu.insert(act, i);
            }
            menu.insert(new JSeparator(), 0);
            JMenu rangeMenu = new JMenu("Axes range");
            JMenuItem it = new JCheckBoxMenuItem("Ignore metadata", TrendPlotter.this.ignoreMeta);
            it.addActionListener(e -> {
                JCheckBoxMenuItem box = (JCheckBoxMenuItem)e.getSource();
                boolean isSelected = box.isSelected();
                if (TrendPlotter.this.ignoreMeta != isSelected) {
                    TrendPlotter.this.ignoreMeta = isSelected;
                    TrendPlotter.this.isCustomRangeV = false;
                    TrendPlotter.access$1902(TrendPlotter.this, null);
                    TrendPlotter.this.replot();
                }
            });
            rangeMenu.add(it);
            it = new JMenuItem("Reset");
            it.addActionListener(e -> {
                TrendPlotter.this.isCustomRangeT = false;
                TrendPlotter.access$1702(TrendPlotter.this, null);
                TrendPlotter.this.isCustomRangeV = false;
                TrendPlotter.access$1902(TrendPlotter.this, null);
                if (TrendPlotter.this.oldTimeWindow == null) {
                    TrendPlotter.this.replot();
                } else {
                    SwingUtilities.invokeLater(() -> {
                        TrendPlotter.this.plugin.refresh(TrendPlotter.this, TrendPlotter.this.oldTimeWindow, null);
                        TrendPlotter.this.oldTimeWindow = null;
                    });
                }
            });
            rangeMenu.add(it);
            menu.insert(rangeMenu, 0);
            JMenu metaMenu = new JMenu("Show metadata");
            ButtonGroup bg = new ButtonGroup();
            Meta.getOnPointSet().forEach(meta -> {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(meta.toString(), TrendPlotter.this.metaOnPoint == meta);
                bg.add(item);
                item.addActionListener(e -> {
                    Meta selected = Meta.valueOf(e.getActionCommand());
                    if (selected != TrendPlotter.this.metaOnPoint) {
                        TrendPlotter.this.metaOnPoint = selected;
                    } else {
                        TrendPlotter.this.metaOnPoint = null;
                    }
                    if (TrendPlotter.this.trends.size() == 1) {
                        Jas3Source dataset = ((TrendInfo)((TrendPlotter)TrendPlotter.this).trends.get((int)0)).data.get(0);
                        dataset.update();
                        TrendPlotter.this.setPlotProperties();
                        dataset.replot();
                    } else {
                        TrendPlotter.this.trends.forEach(info -> info.data.get(0).update());
                        TrendPlotter.this.setPlotProperties();
                        TrendPlotter.this.trends.forEach(info -> info.data.get(0).replot());
                    }
                });
                metaMenu.add(item);
            });
            metaMenu.addSeparator();
            Meta.getOffPointSet().forEach(meta -> {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(meta.toString(), TrendPlotter.this.metaOffPoint.contains(meta));
                item.setEnabled(TrendPlotter.this.trends.size() < 2);
                item.addActionListener(e -> {
                    JCheckBoxMenuItem mi;
                    boolean isSelected;
                    Meta m = Meta.valueOf(e.getActionCommand());
                    boolean wasSelected = TrendPlotter.this.metaOffPoint.contains((Object)m);
                    if (wasSelected != (isSelected = (mi = (JCheckBoxMenuItem)e.getSource()).isSelected())) {
                        if (wasSelected) {
                            TrendPlotter.this.metaOffPoint.remove((Object)m);
                        } else {
                            TrendPlotter.this.metaOffPoint.add(m);
                        }
                        TrendPlotter.this.replot();
                    }
                });
                metaMenu.add(item);
            });
            menu.insert(metaMenu, 0);
            return menu;
        }
    }

    private class TrendInfo {
        Trend trend;
        List<Jas3Source> data;
        int messageID;

        TrendInfo(Trend trend, Jas3Source dataset) {
            this.trend = trend;
            this.data = new ArrayList<Jas3Source>(1);
            this.data.add(dataset);
        }

        TrendInfo(Trend trend) {
            this.trend = trend;
            this.data = new ArrayList<Jas3Source>(1);
        }

        boolean hasOffPoint() {
            return this.data.size() > 1;
        }

        void removeOffPoint() {
            Jas3Source onPoint = this.data.get(0);
            this.data = new ArrayList<Jas3Source>(1);
            this.data.add(onPoint);
        }
    }

    private class Jas3Source
    extends Observable
    implements JAS3DataSource,
    XYDataSource,
    HasStyle {
        private final int trendIndex;
        private final String title;
        private final String key;
        private long[] t;
        private double[] y;
        private double[] plusError;
        private double[] minusError;
        private final JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        private double[] vRange;
        private double base;
        private double step = -1.0;

        Jas3Source(int trendIndex, Meta meta, String key) {
            Color color;
            this.trendIndex = trendIndex;
            this.key = key;
            Trend trend = ((TrendInfo)((TrendPlotter)TrendPlotter.this).trends.get((int)trendIndex)).trend;
            if (key == null) {
                this.title = trend.getDescriptor().getTitle();
                color = colors[trendIndex % colors.length];
                this.style.setShowDataPoints(true);
                this.style.setShowErrorBars(true);
            } else {
                this.title = meta.toString();
                color = meta.getColor();
                this.style.setShowDataPoints(false);
                this.style.setShowErrorBars(false);
            }
            this.style.setDataPointColor(color);
            this.style.setErrorBarColor(color);
            this.style.setLineColor(color);
            this.style.setDataPointStyle(0);
            this.style.setShowHistogramBars(false);
            this.style.setShowLinesBetweenPoints(true);
            this.populate();
        }

        public void destroy() {
        }

        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        }

        public DataSource dataSource() {
            return this;
        }

        public FTreePath path() {
            return new FTreePath(this.getTitle());
        }

        public String[] axisLabels() {
            return null;
        }

        public void setAxisType(int type) {
        }

        public int getNPoints() {
            return this.t == null ? 0 : this.t.length;
        }

        public double getX(int i) {
            return (double)this.t[i] / 1000.0;
        }

        public double getY(int i) {
            return this.step < 0.0 ? this.y[i] : this.base + this.y[i] * this.step;
        }

        public double getPlusError(int i) {
            return this.plusError == null ? 0.0 : this.plusError[i];
        }

        public double getMinusError(int i) {
            return this.minusError == null ? 0.0 : this.minusError[i];
        }

        public int getAxisType() {
            return 3;
        }

        public String getTitle() {
            return this.title;
        }

        public JASHistStyle getStyle() {
            return this.style;
        }

        private void populate() {
            TrendData td = ((TrendInfo)((TrendPlotter)TrendPlotter.this).trends.get((int)this.trendIndex)).trend.getData();
            if (td == null) {
                this.t = null;
                this.minusError = null;
                this.plusError = null;
                this.y = null;
            } else if (this.key == null) {
                this.t = td.getTimes();
                this.y = td.getValues();
                if (TrendPlotter.this.metaOnPoint == null) {
                    this.plusError = null;
                    this.minusError = null;
                } else {
                    List<String> keys = TrendPlotter.this.metaOnPoint.getKeys();
                    int n = keys.size();
                    double[][] in = new double[n + 1][];
                    in[0] = this.y;
                    for (int i = 0; i < n; ++i) {
                        in[i + 1] = td.getValues(keys.get(i));
                    }
                    double[][] out = TrendPlotter.this.metaOnPoint.getBars(in);
                    this.minusError = out[0];
                    this.plusError = out[1];
                }
            } else {
                this.t = td.getTimes(this.key);
                this.y = td.getValues(this.key);
            }
            this.vRange = null;
        }

        private void computeValueRange() {
            int n = this.getNPoints();
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            if (TrendPlotter.this.ignoreMeta) {
                for (int i = 0; i < n; ++i) {
                    double v = this.getY(i);
                    if (v < min) {
                        min = v;
                    }
                    if (!(v > max)) continue;
                    max = v;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    double v = this.getY(i);
                    double d = v - this.getMinusError(i);
                    if (d < min) {
                        min = d;
                    }
                    if (!((d = v + this.getPlusError(i)) > max)) continue;
                    max = d;
                }
            }
            this.vRange = new double[]{min, max};
        }

        private void update() {
            this.populate();
            this.setChanged();
        }

        private void replot() {
            this.notifyObservers(new HistogramUpdate(2, false));
        }

        private double[] getValueRange() {
            if (this.vRange == null) {
                this.computeValueRange();
            }
            return this.vRange;
        }

        private void calibrate(double base, double step) {
            this.base = base;
            this.step = step;
            this.setChanged();
            this.replot();
        }
    }

    public static class Style {
        Meta onPoint;
        EnumSet<Meta> offPoint;

        public Style() {
        }

        public Style(Meta onPoint, EnumSet<Meta> offPoint) {
            this.onPoint = onPoint;
            this.offPoint = offPoint;
        }

        public Meta getOnPoint() {
            return this.onPoint;
        }

        public void setOnPoint(Meta onnPoint) {
            this.onPoint = onnPoint;
        }

        public EnumSet<Meta> getOffPoint() {
            return this.offPoint;
        }

        public void setOffPoint(EnumSet<Meta> offPoint) {
            this.offPoint = offPoint;
        }
    }

    static enum Option {
        EXIST,
        NEWPAGE,
        NEWPLOT,
        OVERLAY,
        SLOW,
        REPLOT;

    }
}

