/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DATAREADERVIEW_QOS_DEFAULT;
import DDS.DataReader;
import DDS.DataReaderView;
import DDS.DataReaderViewQos;
import DDS.DataReaderViewQosHolder;
import DDS.QueryCondition;
import DDS.ReadCondition;
import DDS.StatusCondition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensplice.dds.dcps.DataReaderImpl;
import org.opensplice.dds.dcps.DataReaderViewBase;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.QueryConditionImpl;
import org.opensplice.dds.dcps.ReadConditionImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.Utilities;

public class DataReaderViewImpl
extends DataReaderViewBase
implements DataReaderView {
    private static final long serialVersionUID = 8794005356602301039L;
    private DataReaderImpl reader = null;
    private final Set<ReadConditionImpl> conditions = new HashSet<ReadConditionImpl>();

    protected DataReaderViewImpl() {
    }

    protected int init(DataReaderImpl reader, String name, DataReaderViewQos qos) {
        int result = 0;
        long uReader = reader.get_user_object();
        if (uReader != 0L) {
            long uView;
            if (result == 0 && (uView = this.jniDataReaderViewNew(uReader, name, qos)) != 0L) {
                this.set_user_object(uView);
                this.reader = reader;
                this.setDomainId(reader.getDomainId());
            }
        } else {
            result = 9;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        long uView = 0L;
        DataReaderViewImpl dataReaderViewImpl = this;
        synchronized (dataReaderViewImpl) {
            uView = this.get_user_object();
            if (uView != 0L) {
                if (this.conditions.size() == 0) {
                    result = this.detach_statuscondition();
                    if (result == 0) {
                        this.reader = null;
                        result = this.jniDataReaderViewFree(uView);
                        if (result == 0) {
                            result = super.deinit();
                        }
                    }
                } else {
                    result = 4;
                    ReportStack.report(result, "DataReaderView still contains '" + this.conditions.size() + "' Condition entities.");
                }
            } else {
                result = 4;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadCondition create_readcondition(int sample_states, int view_states, int instance_states) {
        int result = 0;
        ReadConditionImpl readCondition = null;
        ReportStack.start();
        result = Utilities.checkSampleStateMask(sample_states);
        if (result == 0 && (result = Utilities.checkViewStateMask(view_states)) == 0 && (result = Utilities.checkInstanceStateMask(instance_states)) == 0) {
            readCondition = new ReadConditionImpl();
            DataReaderViewImpl dataReaderViewImpl = this;
            synchronized (dataReaderViewImpl) {
                result = readCondition.init(this, sample_states, view_states, instance_states, 0L);
                if (result == 0) {
                    this.conditions.add(readCondition);
                } else {
                    readCondition = null;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return readCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCondition create_querycondition(int sample_states, int view_states, int instance_states, String query_expression, String[] query_parameters) {
        QueryConditionImpl queryCondition = null;
        int result = 0;
        ReportStack.start();
        if (query_expression == null) {
            result = 3;
            ReportStack.report(result, "query_expression 'null' is invalid.");
        } else {
            result = Utilities.checkSampleStateMask(sample_states);
            if (result == 0 && (result = Utilities.checkViewStateMask(view_states)) == 0 && (result = Utilities.checkInstanceStateMask(instance_states)) == 0) {
                queryCondition = new QueryConditionImpl();
                DataReaderViewImpl dataReaderViewImpl = this;
                synchronized (dataReaderViewImpl) {
                    result = queryCondition.init(this, sample_states, view_states, instance_states, query_expression, query_parameters);
                    if (result == 0) {
                        this.conditions.add(queryCondition);
                    } else {
                        queryCondition = null;
                    }
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return queryCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_readcondition(ReadCondition a_condition) {
        int result = 0;
        ReportStack.start();
        if (a_condition == null) {
            result = 3;
            ReportStack.report(result, "a_condition 'null' is invalid.");
        } else {
            DataReaderViewImpl dataReaderViewImpl = this;
            synchronized (dataReaderViewImpl) {
                ReadConditionImpl rc = (ReadConditionImpl)a_condition;
                if (this.conditions.remove(rc)) {
                    result = rc.deinit();
                    if (result != 0 && result != 9) {
                        this.conditions.add(rc);
                    }
                } else if (rc.get_user_object() == 0L) {
                    result = 9;
                } else {
                    result = 4;
                    ReportStack.report(result, "Condition not created by DataReaderView.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_contained_entities() {
        int endResult = 0;
        ReportStack.start();
        DataReaderViewImpl dataReaderViewImpl = this;
        synchronized (dataReaderViewImpl) {
            if (this.get_user_object() != 0L) {
                Iterator<ReadConditionImpl> it = this.conditions.iterator();
                while (it.hasNext()) {
                    int result = it.next().deinit();
                    if (result == 0 || result == 9) {
                        it.remove();
                    }
                    if (result == 0) continue;
                    ReportStack.report(result, "Deletion of ReadCondition contained in DataReaderView failed.");
                    if (endResult != 0) continue;
                    endResult = result;
                }
            } else {
                endResult = 9;
            }
        }
        ReportStack.flush(this, endResult != 0);
        return endResult;
    }

    @Override
    public int set_qos(DataReaderViewQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAREADERVIEW_QOS_DEFAULT.value) {
            DataReaderViewQosHolder holder = new DataReaderViewQosHolder();
            this.reader.get_default_datareaderview_qos(holder);
            qos = holder.value;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uView = this.get_user_object();
            result = uView != 0L ? this.jniSetQos(uView, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(DataReaderViewQosHolder qos) {
        long uView = 0L;
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            uView = this.get_user_object();
            result = uView != 0L ? this.jniGetQos(uView, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DataReader get_datareader() {
        return this.reader;
    }

    @Override
    public StatusCondition get_statuscondition() {
        return null;
    }

    @Override
    public int get_status_changes() {
        ReportStack.start();
        int status = this.reader.get_status_changes();
        ReportStack.flush(this, status == 0);
        return status;
    }

    @Override
    protected int notify(Event e) {
        return 0;
    }

    private native long jniDataReaderViewNew(long var1, String var3, DataReaderViewQos var4);

    private native int jniDataReaderViewFree(long var1);

    private native int jniSetQos(long var1, DataReaderViewQos var3);

    private native int jniGetQos(long var1, DataReaderViewQosHolder var3);
}

