/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.ui.REBConfigPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class RaftsControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final String LF = "\n";
    private final JPanel mainPanel = UiUtilities.newBorderedPanel(null);
    private final JPanel subMainPanel = new JPanel();
    private final JPanel raftsStPanel = new JPanel();
    private JLabel lblStValue;
    private final JPanel rebStPanel = new JPanel();
    private JLabel lblRebs;
    private final JPanel cfgPanel = UiUtilities.newBorderedPanel((String)"Config");
    private JButton[] btnCfgREB = new JButton[0];
    private JButton btnCfgSave;
    private final JPanel setPanel = UiUtilities.newBorderedPanel((String)"Setup");
    private JButton btnLoadDacs;
    private JButton btnLoadAspics;
    private JCheckBox cbxBackBias;
    private final JPanel seqPanel = UiUtilities.newBorderedPanel((String)"Sequencer");
    private JButton btnSeqLoad;
    private JButton btnSeqStart;
    private JButton btnSeqStop;
    private JButton btnSeqStep;
    private JButton btnResetScan;
    private JButton btnResetFE;
    private JCheckBox cbxScanMode;
    private JCheckBox cbxPattern;
    private final JPanel imgPanel = UiUtilities.newBorderedPanel((String)"Images");
    private JButton btnAcquire;
    private JButton btnSetDir;
    private JButton btnSaveRaw;
    private JButton btnSaveFits;
    private final JPanel msgPanel = UiUtilities.newBorderedPanel((String)"Messages");
    private final JTextArea taMessage = new JTextArea(8, 40);
    private final JScrollPane spMessage = new JScrollPane(this.taMessage);
    private static final Logger LOG = Logger.getLogger((String)RaftsControlPanel.class.getName());
    private final UiUtilities uiUtils;
    private final CommandSender sender;
    private List<String> rebNames = new ArrayList<String>();
    private static final Map<String, REBConfigPanel> rebConfigMap = new HashMap<String, REBConfigPanel>();
    private String imageDir;
    private boolean active;
    private int aspicCount;
    private static final long serialVersionUID = 1L;

    public RaftsControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initStatusPanels();
        this.initConfigPanel();
        this.initSetupPanel();
        this.initSequencerPanel();
        this.initImagePanel();
        this.initSubMainPanel();
        this.initMessagePanel();
        this.initMainPanel();
        this.initTopPanel();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void enablePanel() {
        this.active = true;
        SwingUtilities.invokeLater(new UpdateStatus());
    }

    public void disablePanel() {
        this.active = false;
        SwingUtilities.invokeLater(new UpdateStatus());
    }

    public void reportImage(ImageState state) {
        String message = String.format("Received image: timestamp = %016x, length = %s", state.getTimestamp(), state.getLength());
        this.updateMessage(message);
    }

    void sendCommand(boolean reply, String name, String command, Object ... params) {
        if (this.active) {
            this.sender.sendCommand(reply, name, command, params);
        } else {
            this.displayError("Rafts system not running");
        }
    }

    public void onCommandReply(Object reply, final String path, String command, Object[] args) {
        switch (command) {
            case "getFullState": {
                this.enablePanel();
                break;
            }
            case "setREBConfig": {
                this.display(path + " configuration applied");
                this.sendCommand(true, path, "getREBConfig", new Object[0]);
                break;
            }
            case "getREBConfig": {
                REBConfigPanel panel = rebConfigMap.get(path);
                if (panel != null) {
                    panel.setConfig((REB)reply);
                    break;
                }
                panel = new REBConfigPanel((REB)reply, path, this);
                rebConfigMap.put(path, panel);
                Window pWindow = SwingUtilities.getWindowAncestor(this);
                final JDialog dlg = new JDialog(pWindow, path + " Configuration", Dialog.ModalityType.MODELESS);
                dlg.add((Component)panel, "Center");
                dlg.pack();
                dlg.setLocationRelativeTo(pWindow);
                dlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        rebConfigMap.remove(path);
                        dlg.setVisible(false);
                        dlg.dispose();
                    }
                });
                dlg.setVisible(true);
                break;
            }
            case "loadDacs": {
                this.display((Integer)reply + (path == null ? "" : " " + path) + " DACs loaded");
                this.sendCommand(true, path, "loadBiasDacs", true);
                break;
            }
            case "loadBiasDacs": {
                this.display((Integer)reply + (path == null ? "" : " " + path) + " bias DACs loaded");
                break;
            }
            case "loadAspics": {
                this.aspicCount = (Integer)reply;
                this.sendCommand(true, path, "checkAspics", new Object[0]);
                break;
            }
            case "checkAspics": {
                ArrayList<Integer> masks;
                if (path == null) {
                    masks = (ArrayList<Integer>)reply;
                } else {
                    masks = new ArrayList<Integer>();
                    masks.add((Integer)reply);
                }
                this.display(this.aspicCount + (path == null ? "" : " " + path) + " ASPICs loaded: " + this.getResult(masks));
                break;
            }
            case "loadSequencer": {
                List nSlice = (List)reply;
                StringBuilder msg = new StringBuilder("Slice counts = ");
                boolean first = true;
                Iterator iterator = nSlice.iterator();
                while (iterator.hasNext()) {
                    int count = (Integer)iterator.next();
                    msg.append(first ? "" : ", ").append(count);
                    first = false;
                }
                this.display(msg.toString());
                break;
            }
            case "setBackBias": {
                this.setBackBiasCB();
                break;
            }
            case "isBackBiasOn": {
                List bValues = (List)reply;
                boolean on = true;
                Iterator iterator = bValues.iterator();
                while (iterator.hasNext()) {
                    boolean val = (Boolean)iterator.next();
                    on = !val ? false : on;
                }
                this.cbxBackBias.setSelected(on);
                break;
            }
            case "enableScan": {
                this.setScanModeCB();
                break;
            }
            case "isScanEnabled": {
                List bValues = (List)reply;
                boolean scanMode = true;
                Iterator val = bValues.iterator();
                while (val.hasNext()) {
                    boolean val2 = (Boolean)val.next();
                    scanMode = !val2 ? false : scanMode;
                }
                this.cbxScanMode.setSelected(scanMode);
                break;
            }
            case "setDataSource": {
                this.setPatternCB();
                break;
            }
            case "getDataSource": {
                List iValues = (List)reply;
                boolean pattern = true;
                Iterator iterator = iValues.iterator();
                while (iterator.hasNext()) {
                    int val = (Integer)iterator.next();
                    pattern = (val & 1) == 0 ? false : pattern;
                }
                this.cbxPattern.setSelected(pattern);
                break;
            }
            case "resetFirmware": {
                this.setScanModeCB();
                this.setPatternCB();
                break;
            }
            case "saveImage": 
            case "saveFitsImage": {
                List names = (List)reply;
                this.display("The following files were created:");
                for (String name : names) {
                    this.display("  " + name);
                }
                break;
            }
            case "getREBDeviceNames": {
                this.rebNames = (List)reply;
                StringBuilder text = new StringBuilder();
                for (String name : this.rebNames) {
                    text.append(" ").append(name);
                }
                this.lblRebs.setText(text.toString());
                this.updateConfig();
                this.updateSetup();
                this.setPatternCB();
                this.setScanModeCB();
                this.enableButtons(true);
                break;
            }
            default: {
                this.displayError("Reply received from unrecognized command: " + command);
            }
        }
    }

    void display(String message) {
        this.taMessage.append(message + LF);
    }

    public void handleButton(String name) {
        switch (name.substring(0, 2)) {
            case "CR": {
                this.cfgREB(name.substring(2));
                break;
            }
            case "CS": {
                this.sendCommand(false, null, "saveNamedConfig", "");
                break;
            }
            case "LD": {
                this.sendCommand(true, null, "loadDacs", true);
                break;
            }
            case "LA": {
                this.sendCommand(true, null, "loadAspics", true);
                break;
            }
            case "LS": {
                this.seqLoad();
                break;
            }
            case "SS": {
                this.sendCommand(false, null, "startSequencer", new Object[0]);
                break;
            }
            case "OS": {
                this.sendCommand(false, null, "stopSequencer", new Object[0]);
                break;
            }
            case "ES": {
                this.sendCommand(false, null, "stepSequencer", new Object[0]);
                break;
            }
            case "RS": {
                this.sendCommand(false, null, "resetScan", new Object[0]);
                break;
            }
            case "RF": {
                this.sendCommand(true, null, "resetFirmware", new Object[0]);
                break;
            }
            case "AI": {
                this.sendCommand(false, null, "acquireImage", new Object[0]);
                break;
            }
            case "SD": {
                this.setImageDir();
                break;
            }
            case "SR": {
                this.saveImage("saveImage");
                break;
            }
            case "SF": {
                this.saveImage("saveFitsImage");
            }
        }
    }

    public void handleCheckBox(String name, boolean chkd) {
        switch (name.charAt(0)) {
            case 'B': {
                this.sendCommand(true, null, "setBackBias", chkd);
                break;
            }
            case 'S': {
                this.sendCommand(true, null, "enableScan", chkd);
                break;
            }
            case 'D': {
                this.sendCommand(true, null, "setDataSource", chkd ? 1 : 0);
            }
        }
    }

    void closeConfig(String name) {
        JPanel pnl = rebConfigMap.get(name);
        if (pnl != null) {
            rebConfigMap.remove(name);
            JDialog dlg = (JDialog)SwingUtilities.getWindowAncestor(pnl);
            dlg.setVisible(false);
            dlg.dispose();
        }
    }

    private void initStatusPanels() {
        this.lblStValue = UiUtilities.newLabel((String)"X", (int)UiUtilities.maxLabelWidth((String[])new String[]{"RUNNING", "STOPPED"}, (String)""));
        this.lblStValue.setForeground(UiConstants.RED);
        this.lblStValue.setText("STOPPED");
        this.raftsStPanel.add(UiUtilities.newLabel((String)"Rafts Status: ", (int)0));
        this.raftsStPanel.add(this.lblStValue);
        this.lblRebs = UiUtilities.newLabel((String)"none", (int)-1);
        this.rebStPanel.add(UiUtilities.newLabel((String)"Connected REBs:", (int)0));
        this.rebStPanel.add(this.lblRebs);
    }

    private void initConfigPanel() {
        this.btnCfgREB = new JButton[this.rebNames.size()];
        for (int j = 0; j < this.btnCfgREB.length; ++j) {
            String name = this.rebNames.get(j);
            this.btnCfgREB[j] = this.uiUtils.newButton(name + "...", "CR" + name);
        }
        this.btnCfgSave = this.uiUtils.newButton("Save", "CS");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (JButton btn : this.btnCfgREB) {
            this.cfgPanel.add((Component)btn, gbc);
            ++gbc.gridy;
        }
        this.cfgPanel.add((Component)this.btnCfgSave, gbc);
    }

    private void initSetupPanel() {
        this.btnLoadDacs = this.uiUtils.newButton("Load DACs", "LD");
        this.btnLoadAspics = this.uiUtils.newButton("Load ASPICs", "LA");
        this.cbxBackBias = this.uiUtils.newCheckBox("Back Bias", "B");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.setPanel.add((Component)this.btnLoadDacs, gbc);
        ++gbc.gridy;
        this.setPanel.add((Component)this.btnLoadAspics, gbc);
        ++gbc.gridy;
        this.setPanel.add((Component)this.cbxBackBias, gbc);
    }

    private void initSequencerPanel() {
        this.btnSeqLoad = this.uiUtils.newButton("Load...", "LS");
        this.btnSeqStart = this.uiUtils.newButton("Start", "SS");
        this.btnSeqStop = this.uiUtils.newButton("Stop", "OS");
        this.btnSeqStep = this.uiUtils.newButton("Step", "ES");
        this.cbxScanMode = this.uiUtils.newCheckBox("Scan Mode", "S");
        this.btnResetScan = this.uiUtils.newButton("Reset Scan", "RS");
        this.cbxPattern = this.uiUtils.newCheckBox("Pattern", "D");
        this.btnResetFE = this.uiUtils.newButton("Reset FE", "RF");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.seqPanel.add((Component)this.btnSeqLoad, gbc);
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnSeqStart, gbc);
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnSeqStop, gbc);
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnSeqStep, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.seqPanel.add((Component)this.cbxScanMode, gbc);
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnResetScan, gbc);
        ++gbc.gridy;
        this.seqPanel.add((Component)this.cbxPattern, gbc);
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnResetFE, gbc);
    }

    private void initImagePanel() {
        this.btnAcquire = this.uiUtils.newButton("Acquire", "AI");
        this.btnSetDir = this.uiUtils.newButton("Directory...", "SD");
        this.btnSaveRaw = this.uiUtils.newButton("Save Raw", "SR");
        this.btnSaveFits = this.uiUtils.newButton("Save FITS", "SF");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.imgPanel.add((Component)this.btnAcquire, gbc);
        ++gbc.gridy;
        this.imgPanel.add((Component)this.btnSetDir, gbc);
        ++gbc.gridy;
        this.imgPanel.add((Component)this.btnSaveRaw, gbc);
        ++gbc.gridy;
        this.imgPanel.add((Component)this.btnSaveFits, gbc);
    }

    private void initSubMainPanel() {
        this.subMainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.subMainPanel.add((Component)this.cfgPanel, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        this.subMainPanel.add((Component)this.setPanel, gbc);
        ++gbc.gridx;
        this.subMainPanel.add((Component)this.seqPanel, gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        this.subMainPanel.add((Component)this.imgPanel, gbc);
    }

    private void initMessagePanel() {
        this.msgPanel.add(this.spMessage);
        this.spMessage.setMinimumSize(this.spMessage.getPreferredSize());
        this.taMessage.setEditable(false);
    }

    private void initMainPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = new Insets(10, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.mainPanel.add((Component)this.raftsStPanel, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 10;
        ++gbc.gridy;
        this.mainPanel.add((Component)this.rebStPanel, gbc);
        gbc.insets.top = 10;
        ++gbc.gridy;
        this.mainPanel.add((Component)this.subMainPanel, gbc);
        ++gbc.gridy;
        this.mainPanel.add((Component)this.msgPanel, gbc);
    }

    private void initTopPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        this.add((Component)this.mainPanel, gbc);
    }

    private void cfgREB(String name) {
        JPanel pnl = rebConfigMap.get(name);
        if (pnl != null) {
            SwingUtilities.getWindowAncestor(pnl).toFront();
        } else {
            this.sendCommand(true, name, "getREBConfig", new Object[0]);
        }
    }

    private String getResult(List<Integer> masks) {
        if (masks == null) {
            return "check not done";
        }
        int sum = 0;
        for (int mask : masks) {
            sum |= mask;
        }
        if (sum == 0) {
            return "no errors";
        }
        StringBuilder result = new StringBuilder("mismatches =");
        for (int mask : masks) {
            result.append(String.format(" %08x", mask));
        }
        return result.toString();
    }

    private void seqLoad() {
        String fn;
        JFileChooser fc = new JFileChooser("./");
        fc.setFileFilter(new FileNameExtensionFilter(null, "xml", "seq", "sif"));
        if (fc.showOpenDialog(this.getTopFrame()) != 0) {
            return;
        }
        try {
            fn = fc.getSelectedFile().getCanonicalPath();
        }
        catch (IOException e) {
            this.displayError(e.toString());
            return;
        }
        this.sendCommand(true, null, "loadSequencer", fn);
    }

    private void setBackBiasCB() {
        this.sendCommand(true, null, "isBackBiasOn", new Object[0]);
    }

    private void setScanModeCB() {
        this.sendCommand(true, null, "isScanEnabled", new Object[0]);
    }

    private void setPatternCB() {
        this.sendCommand(true, null, "getDataSource", new Object[0]);
    }

    private void setImageDir() {
        JFileChooser fc = new JFileChooser(this.imageDir == null ? "./" : this.imageDir);
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this.getTopFrame()) == 0) {
            this.imageDir = fc.getSelectedFile().getPath();
        }
    }

    private void saveImage(String cmnd) {
        if (this.imageDir != null) {
            this.sendCommand(true, null, cmnd, this.imageDir);
        } else {
            this.displayError("Image directory hasn't been set");
        }
    }

    private void updateConfig() {
        if (this.rebNames.size() != this.btnCfgREB.length) {
            this.cfgPanel.removeAll();
            this.initConfigPanel();
        } else {
            for (int j = 0; j < this.btnCfgREB.length; ++j) {
                this.btnCfgREB[j].setName(this.rebNames.get(j) + "...");
            }
        }
    }

    private void updateSetup() {
        this.setBackBiasCB();
    }

    private Component getTopFrame() {
        Container c = this;
        while (!(c instanceof JFrame || c instanceof JWindow || c instanceof JDialog || c.getParent() == null)) {
            c = c.getParent();
        }
        return c;
    }

    private void updateMessage(String msg) {
        SwingUtilities.invokeLater(new UpdateMessage(msg));
    }

    private void displayError(String message) {
        this.taMessage.append(message + LF);
    }

    private void enableButtons(boolean enable) {
        for (JButton b : this.btnCfgREB) {
            b.setEnabled(enable);
        }
        this.btnCfgSave.setEnabled(enable);
        this.btnLoadDacs.setEnabled(enable);
        this.btnLoadAspics.setEnabled(enable);
        this.cbxBackBias.setEnabled(enable);
        this.btnSeqLoad.setEnabled(enable);
        this.btnSeqStart.setEnabled(enable);
        this.btnSeqStop.setEnabled(enable);
        this.btnSeqStep.setEnabled(enable);
        this.cbxScanMode.setEnabled(enable);
        this.btnResetScan.setEnabled(enable);
        this.cbxPattern.setEnabled(enable);
        this.btnResetFE.setEnabled(enable);
        this.btnAcquire.setEnabled(enable);
        this.btnSaveRaw.setEnabled(enable);
        this.btnSaveFits.setEnabled(enable);
        this.repaint();
    }

    class UpdateStatus
    implements Runnable {
        UpdateStatus() {
        }

        @Override
        public void run() {
            if (RaftsControlPanel.this.active) {
                RaftsControlPanel.this.lblStValue.setText("RUNNING");
                RaftsControlPanel.this.lblStValue.setForeground(UiConstants.GREEN);
                RaftsControlPanel.this.sendCommand(true, null, "getREBDeviceNames", new Object[0]);
            } else {
                RaftsControlPanel.this.lblStValue.setText("STOPPED");
                RaftsControlPanel.this.lblStValue.setForeground(UiConstants.RED);
                RaftsControlPanel.this.enableButtons(false);
            }
        }
    }

    class UpdateMessage
    implements Runnable {
        String message;

        UpdateMessage(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            RaftsControlPanel.this.display(this.message);
        }
    }
}

