/*
 * Decompiled with CFR 0.152.
 */
package mover;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

class MoverGlassPane
extends JComponent {
    private Component content;
    private Component currentChild;
    private Point dragOffset;
    private HandleBorder handle = new HandleBorder(Color.BLUE);
    private Point startLocation;
    private Rectangle startBounds;
    private Dimension zeroDimension = new Dimension(0, 0);
    private boolean dragInProgress = false;

    MoverGlassPane(Component content) {
        this.content = content;
        this.enableEvents(48L);
    }

    void setContent(Component content) {
        this.content = content;
    }

    @Override
    public boolean contains(int x, int y) {
        Component child;
        if (!this.dragInProgress && !this.handle.contains(x, y, true) && (child = this.content.getComponentAt(x, y)) != this.content && child != this.currentChild) {
            this.currentChild = child;
            this.handle.setLocation(child);
            this.repaint();
        }
        return this.handle.contains(x, y, false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.currentChild != null) {
            this.handle.paintBorder(g);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            this.setCursor(this.handle.getCursor(e.getX(), e.getY()));
        } else if (e.getID() == 506) {
            if (this.getCursor().getType() == 13) {
                Point p = e.getPoint();
                p.translate(-this.dragOffset.x, -this.dragOffset.y);
                p.translate(this.startLocation.x, this.startLocation.y);
                this.currentChild.setLocation(p);
            } else {
                int d;
                int type;
                Point p = e.getPoint();
                p.translate(-this.startLocation.x, -this.startLocation.y);
                Rectangle b = new Rectangle(this.startBounds);
                Dimension minimum = this.zeroDimension;
                if (this.currentChild instanceof JComponent) {
                    minimum = ((JComponent)this.currentChild).getMinimumSize();
                }
                if ((type = this.getCursor().getType()) == 11 || type == 7 || type == 5) {
                    b.width = Math.max(p.x, minimum.width);
                }
                if (type == 10 || type == 6 || type == 4) {
                    d = Math.min(p.x, b.width - minimum.width);
                    b.width -= d;
                    b.x += d;
                }
                if (type == 8 || type == 7 || type == 6) {
                    d = Math.min(p.y, b.height - minimum.height);
                    b.height -= d;
                    b.y += d;
                }
                if (type == 9 || type == 5 || type == 4) {
                    b.height = Math.max(p.y, minimum.height);
                }
                this.currentChild.setBounds(b);
            }
            this.repaint();
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.dragOffset = e.getPoint();
            this.startLocation = this.currentChild.getLocation();
            this.startBounds = this.currentChild.getBounds();
            this.dragInProgress = true;
        } else if (e.getID() == 502) {
            this.dragInProgress = false;
        }
        super.processMouseEvent(e);
    }

    private static class HandleBorder {
        private Component child;
        private Color lineColor;
        private Rectangle outerBounds = new Rectangle();
        private Rectangle innerBounds = new Rectangle();
        private static int thickness = 5;
        private static int thick2 = thickness / 2;
        private static Handle[] handles = new Handle[8];

        HandleBorder(Color color) {
            this.lineColor = color;
        }

        void setLocation(Component child) {
            this.child = child;
        }

        public void paintBorder(Graphics g) {
            Color oldColor = g.getColor();
            int xx = this.child.getX() - thick2;
            int yy = this.child.getY() - thick2;
            int ww = this.child.getWidth() + thickness;
            int hh = this.child.getHeight() + thickness;
            Handle[] h = this.getHandles(xx, yy, ww, hh);
            g.setColor(this.lineColor);
            g.drawRect(xx - 1, yy - 1, ww, hh);
            for (int i = 0; i < h.length; ++i) {
                g.fillRect(h[i].x, h[i].y, h[i].width, h[i].height);
            }
            g.setColor(oldColor);
        }

        boolean contains(int x, int y, boolean includingContainedComponent) {
            if (this.child == null) {
                return false;
            }
            this.child.getBounds(this.innerBounds);
            if (!includingContainedComponent && this.innerBounds.contains(x, y)) {
                return false;
            }
            this.outerBounds.setLocation(this.innerBounds.x - thickness, this.innerBounds.y - thickness);
            this.outerBounds.setSize(this.innerBounds.width + 2 * thickness, this.innerBounds.height + 2 * thickness);
            return this.outerBounds.contains(x, y);
        }

        Cursor getCursor(int x, int y) {
            int xx = this.child.getX() - thick2;
            int yy = this.child.getY() - thick2;
            int ww = this.child.getWidth() + thickness;
            int hh = this.child.getHeight() + thickness;
            Handle[] h = this.getHandles(xx, yy, ww, hh);
            for (int i = 0; i < h.length; ++i) {
                if (!h[i].contains(x, y)) continue;
                return Cursor.getPredefinedCursor(h[i].getCursor());
            }
            return Cursor.getPredefinedCursor(13);
        }

        private Handle[] getHandles(int xx, int yy, int ww, int hh) {
            handles[0].set(6, xx, yy);
            handles[1].set(7, xx + ww, yy);
            handles[2].set(5, xx + ww, yy + hh);
            handles[3].set(4, xx, yy + hh);
            handles[4].set(8, xx + ww / 2, yy);
            handles[5].set(9, xx + ww / 2, yy + hh);
            handles[6].set(10, xx, yy + hh / 2);
            handles[7].set(11, xx + ww, yy + hh / 2);
            return handles;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        static {
            for (int i = 0; i < handles.length; ++i) {
                HandleBorder.handles[i] = new Handle(thickness);
            }
        }

        private static class Handle
        extends Rectangle {
            private int thick2;
            private int type;

            Handle(int size) {
                this.setSize(size, size);
                this.thick2 = size / 2;
            }

            void set(int type, int x, int y) {
                this.setLocation(x - this.thick2 - 1, y - this.thick2 - 1);
                this.type = type;
            }

            int getCursor() {
                return this.type;
            }
        }
    }
}

