/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.config;

import java.io.Serializable;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.DACS;

public class REB
implements Serializable {
    public static final int N_CCD = 3;
    public static final int N_ASIC = 6;
    public static final int VERSION_UNSUPP = -1;
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    private int dacVersion;
    private int biasVersion;
    private int aspicVersion;
    private boolean dacRaw;
    private boolean biasRaw;
    private int id;
    private String ifcName;
    private int ccdMask = 1;
    private int maxCcdMask = 7;
    private final DACS dacs = new DACS();
    private final BiasDACS[] biases = new BiasDACS[3];
    private final ASPIC[] aspics = new ASPIC[6];
    private static final long serialVersionUID = -630477405631882175L;

    public int getDacVersion() {
        return this.dacVersion;
    }

    public void setDacVersion(int version) {
        this.dacVersion = version;
    }

    public int getBiasVersion() {
        return this.biasVersion;
    }

    public void setBiasVersion(int version) {
        this.biasVersion = version;
    }

    public int getAspicVersion() {
        return this.aspicVersion;
    }

    public void setAspicVersion(int version) {
        this.aspicVersion = version;
    }

    public boolean isDacRaw() {
        return this.dacRaw;
    }

    public void setDacRaw(boolean state) {
        this.dacRaw = state;
    }

    public boolean isBiasRaw() {
        return this.biasRaw;
    }

    public void setBiasRaw(boolean state) {
        this.biasRaw = state;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIfcName() {
        return this.ifcName;
    }

    public void setIfcName(String ifcName) {
        this.ifcName = ifcName;
    }

    public int getCcdMask() {
        return this.ccdMask;
    }

    public void setCcdMask(int ccdMask) {
        if ((ccdMask & this.maxCcdMask) != ccdMask) {
            throw new IllegalArgumentException("ccdMask (" + ccdMask + ") should be submask of " + this.maxCcdMask);
        }
        this.ccdMask = ccdMask;
    }

    public int getMaxCcdMask() {
        return this.maxCcdMask;
    }

    public void setMaxCcdMask(int maxCcdMask) {
        this.maxCcdMask = maxCcdMask;
    }

    public DACS getDacs() {
        return this.dacs;
    }

    public BiasDACS[] getBiases() {
        return this.biases;
    }

    public ASPIC[] getAspics() {
        return this.aspics;
    }

    public void copyFrom(REB reb) {
        int j;
        this.id = reb.id;
        this.ifcName = reb.ifcName;
        this.ccdMask = reb.ccdMask;
        this.maxCcdMask = reb.maxCcdMask;
        this.dacVersion = reb.dacVersion;
        this.dacs.copyFrom(reb.dacs);
        this.biasVersion = reb.biasVersion;
        for (j = 0; j < 3; ++j) {
            BiasDACS bias = this.biases[j];
            if (bias == null) continue;
            bias.copyFrom(reb.biases[j]);
        }
        this.aspicVersion = reb.aspicVersion;
        for (j = 0; j < 6; ++j) {
            ASPIC aspic = this.aspics[j];
            if (aspic == null) continue;
            aspic.copyFrom(reb.aspics[j]);
        }
    }
}

