/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.PLCState;
import org.lsst.ccs.subsystem.refrig.constants.PcpHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.PcpHeaters;
import org.lsst.ccs.subsystem.refrig.constants.PcpLatches;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitchState;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitches;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.PcpSysState;

public class PcpControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getSystemState";
    private static final String[] switchNames = new String[2];
    private static final Map<PcpSwitchState, Color> switchColors;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final String[] heaterNames;
    private static final int SWITCH_LABEL_WIDTH;
    private static final int SWITCH_STATE_WIDTH;
    private static final Map<PcpHeaterState, Color> stateColors;
    private SystemStatusPanel systemPanel;
    private JPanel plcPanel;
    private JLabel plcStatus;
    private JPanel switchPanel;
    private final JLabel[] switchStatus = new JLabel[2];
    private final ButtonGroup[] switchBG = new ButtonGroup[2];
    private final JRadioButton[] switchOffRB = new JRadioButton[2];
    private final JRadioButton[] switchOnRB = new JRadioButton[2];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[3];
    private final JLabel[] latchStatus = new JLabel[3];
    private final JButton[] latchResetBtn = new JButton[3];
    private JPanel conditionPanel;
    private final JLabel[] conditionStatus = new JLabel[4];
    private JPanel heaterPanel;
    private final JLabel[] htrSwitchLabel = new JLabel[3];
    private final JLabel[] htrSwitchStatus = new JLabel[3];
    private final JLabel[] powerUnitsLabel = new JLabel[3];
    private final ButtonGroup[] htrSwitchBG = new ButtonGroup[3];
    private final JRadioButton[] htrSwitchOffRB = new JRadioButton[3];
    private final JRadioButton[] htrSwitchOnRB = new JRadioButton[3];
    private final TextFieldX[] powerTextField = new TextFieldX[3];
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private boolean gotTempLimits = false;
    private static final long serialVersionUID = 1L;

    public PcpControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((PcpSysState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(PcpSysState rs) {
        SwingUtilities.invokeLater(new UpdatePcpStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int cond;
        this.systemPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.plcStatus = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(PLCState.class));
        for (int sw = 0; sw < 2; ++sw) {
            this.switchStatus[sw] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(SwitchState.class));
            this.switchOffRB[sw] = this.uiUtils.newRadioButton("Off", "PF" + sw);
            this.switchOnRB[sw] = this.uiUtils.newRadioButton("On", "PT" + sw);
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(this.switchOffRB[sw]);
            bg.add(this.switchOnRB[sw]);
        }
        for (cond = 0; cond < 3; ++cond) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchNames[cond] + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(LatchState.class));
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", String.valueOf(cond), true);
        }
        for (cond = 0; cond < 4; ++cond) {
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(ConditionState.class));
        }
        for (int htr = 0; htr < 3; ++htr) {
            this.htrSwitchLabel[htr] = UiUtilities.newLabel((String)(heaterNames[htr] + ":"), (int)SWITCH_LABEL_WIDTH);
            this.htrSwitchStatus[htr] = UiUtilities.newLabel((String)"OFF", (int)SWITCH_STATE_WIDTH);
            this.htrSwitchOffRB[htr] = this.uiUtils.newRadioButton("Off", "HF" + htr);
            this.htrSwitchOnRB[htr] = this.uiUtils.newRadioButton("On", "HT" + htr);
            this.htrSwitchBG[htr] = new ButtonGroup();
            this.htrSwitchBG[htr].add(this.htrSwitchOffRB[htr]);
            this.htrSwitchBG[htr].add(this.htrSwitchOnRB[htr]);
            this.powerTextField[htr] = this.uiUtils.newTextFieldX("10000.0", String.valueOf(htr), 2, true);
            this.powerUnitsLabel[htr] = UiUtilities.newLabel((String)"W", (int)0);
        }
        this.plcPanel = new JPanel();
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.anchor = 17;
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.insets = new Insets(0, 4, 0, 4);
        this.plcPanel.add((Component)UiUtilities.newLabel((String)"PLC state:", (int)0), gbp);
        ++gbp.gridx;
        this.plcPanel.add((Component)this.plcStatus, gbp);
        this.switchPanel = UiUtilities.newBorderedPanel((String)"PLC Switches");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        gbs.gridy = -1;
        int numColm = 2;
        int colm = 0;
        for (int sw = 0; sw < 2; ++sw) {
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)UiUtilities.newLabel((String)(switchNames[sw] + ":"), (int)0), gbs);
            gbs.insets.left = 4;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 17;
        gbl.insets = new Insets(0, 0, 4, 4);
        gbl.insets.bottom = 4;
        gbl.gridy = -1;
        numColm = 2;
        colm = 0;
        for (int cond2 = 0; cond2 < 3; ++cond2) {
            if (colm == 0) {
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.top = gbl.gridy == 0 ? 4 : 0;
            gbl.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond2], gbl);
            gbl.insets.left = 4;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond2], gbl);
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond2], gbl);
            ++gbl.gridx;
            colm = (colm + 1) % numColm;
        }
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        numColm = 2;
        colm = 0;
        for (int cond3 = 0; cond3 < 4; ++cond3) {
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 35;
            this.conditionPanel.add((Component)UiUtilities.newLabel((String)(conditionNames[cond3] + ":"), (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond3], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % numColm;
        }
        this.heaterPanel = UiUtilities.newBorderedPanel((String)"Heaters");
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.anchor = 17;
        gbh.insets = new Insets(4, 4, 0, 4);
        gbh.gridy = 0;
        for (int htr = 0; htr < 3; ++htr) {
            gbh.insets.bottom = htr == 2 ? 4 : 0;
            gbh.gridx = 0;
            this.heaterPanel.add((Component)this.htrSwitchLabel[htr], gbh);
            ++gbh.gridx;
            this.heaterPanel.add((Component)this.htrSwitchStatus[htr], gbh);
            ++gbh.gridx;
            this.heaterPanel.add((Component)this.htrSwitchOffRB[htr], gbh);
            ++gbh.gridx;
            gbh.insets.right = 0;
            this.heaterPanel.add((Component)this.htrSwitchOnRB[htr], gbh);
            ++gbh.gridx;
            this.heaterPanel.add((Component)this.powerTextField[htr], gbh);
            ++gbh.gridx;
            gbh.insets.right = 4;
            this.heaterPanel.add((Component)this.powerUnitsLabel[htr], gbh);
            ++gbh.gridy;
            gbh.insets.top = 0;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 11;
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.systemPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.plcPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.conditionPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.heaterPanel, gbm);
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int sw = Integer.valueOf(name.substring(2));
        if (type == 'P') {
            this.switchOffRB[sw].setEnabled(false);
            this.switchOnRB[sw].setEnabled(false);
            this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{PcpSwitches.getName(sw), action == 'T'});
        } else {
            this.htrSwitchOffRB[sw].setEnabled(false);
            this.htrSwitchOnRB[sw].setEnabled(false);
            this.sender.sendCommand(null, "setHeaterState", new Object[]{PcpHeaters.getName(sw), action == 'T'});
        }
    }

    public void handleButton(String name) {
        int latch = Integer.valueOf(name);
        this.latchResetBtn[latch].setEnabled(false);
        this.sender.sendCommand(null, "clearLatch", new Object[]{PcpLatches.getName(latch)});
    }

    public void handleTextFieldX(String name, Object value) {
        int htr = Integer.valueOf(name);
        this.powerTextField[htr].setDisabled();
        this.sender.sendCommand(null, "setHeaterPower", new Object[]{PcpHeaters.getName(htr), (Double)value});
    }

    static {
        PcpControlPanel.switchNames[1] = "Block Cold Heater";
        PcpControlPanel.switchNames[0] = "Block Cold Refrig";
        switchColors = new HashMap<PcpSwitchState, Color>();
        switchColors.put(PcpSwitchState.OFF, Color.BLACK);
        switchColors.put(PcpSwitchState.ON, UiConstants.GREEN);
        switchColors.put(PcpSwitchState.ALARM, UiConstants.RED);
        switchColors.put(PcpSwitchState.OFFLINE, UiConstants.BLUE);
        latchNames = new String[3];
        PcpControlPanel.latchNames[1] = "Cold Temp > 99C";
        PcpControlPanel.latchNames[2] = "Cold Temp < -99C";
        PcpControlPanel.latchNames[0] = "Smoke Detc";
        conditionNames = new String[4];
        PcpControlPanel.conditionNames[0] = "Refrig Permit";
        PcpControlPanel.conditionNames[1] = "Heater PS1 Enable";
        PcpControlPanel.conditionNames[2] = "Heater PS2 Enable";
        PcpControlPanel.conditionNames[3] = "Heater PS3 Enable";
        heaterNames = new String[3];
        PcpControlPanel.heaterNames[0] = "-Y";
        PcpControlPanel.heaterNames[2] = "+Y";
        PcpControlPanel.heaterNames[1] = "Center";
        SWITCH_LABEL_WIDTH = UiUtilities.maxLabelWidth((String[])heaterNames, (String)":");
        SWITCH_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(PcpHeaterState.class);
        stateColors = new HashMap<PcpHeaterState, Color>();
        stateColors.put(PcpHeaterState.OFF, Color.BLACK);
        stateColors.put(PcpHeaterState.ON, UiConstants.GREEN);
        stateColors.put(PcpHeaterState.OFFLINE, UiConstants.BLUE);
        stateColors.put(PcpHeaterState.DISABLD, UiConstants.RED);
        stateColors.put(PcpHeaterState.VOLTERR, UiConstants.PURPLE);
        stateColors.put(PcpHeaterState.CANTSET, UiConstants.PURPLE);
        stateColors.put(PcpHeaterState.NOLOAD, UiConstants.PURPLE);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            PcpControlPanel.this.systemPanel.disablePanel();
            PcpControlPanel.this.plcStatus.setEnabled(false);
            for (int sw = 0; sw < 2; ++sw) {
                PcpControlPanel.this.switchStatus[sw].setEnabled(false);
                PcpControlPanel.this.switchOffRB[sw].setEnabled(false);
                PcpControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 3; ++cond) {
                PcpControlPanel.this.latchStatus[cond].setEnabled(false);
                PcpControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (cond = 0; cond < 4; ++cond) {
                PcpControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
            for (int htr = 0; htr < 3; ++htr) {
                PcpControlPanel.this.htrSwitchStatus[htr].setEnabled(false);
                PcpControlPanel.this.htrSwitchOffRB[htr].setEnabled(false);
                PcpControlPanel.this.htrSwitchOnRB[htr].setEnabled(false);
                PcpControlPanel.this.powerTextField[htr].setDisabled();
            }
            PcpControlPanel.this.repaint();
        }
    }

    class UpdatePcpStatus
    implements Runnable {
        private final PcpSysState ps;

        UpdatePcpStatus(PcpSysState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            int cond;
            JRadioButton selButton;
            Enum state;
            PcpControlPanel.this.systemPanel.updatePanel(this.ps.getTickMillis());
            PLCState plcState = this.ps.getPlcState();
            PcpControlPanel.this.plcStatus.setText(plcState.name());
            PcpControlPanel.this.plcStatus.setForeground(plcState == PLCState.OFFLINE ? UiConstants.BLUE : (plcState == PLCState.DEAD ? UiConstants.RED : UiConstants.GREEN));
            PcpControlPanel.this.plcStatus.setEnabled(true);
            for (int sw = 0; sw < 2; ++sw) {
                state = this.ps.getSwitchState(sw);
                PcpControlPanel.this.switchStatus[sw].setText(state.name());
                PcpControlPanel.this.switchStatus[sw].setForeground((Color)switchColors.get(state));
                selButton = state == PcpSwitchState.ON ? PcpControlPanel.this.switchOnRB[sw] : PcpControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                PcpControlPanel.this.switchStatus[sw].setEnabled(true);
                PcpControlPanel.this.switchOffRB[sw].setEnabled(true);
                PcpControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            for (cond = 0; cond < 3; ++cond) {
                state = this.ps.getLatch(cond);
                PcpControlPanel.this.latchStatus[cond].setText(state.name());
                PcpControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                PcpControlPanel.this.latchStatus[cond].setEnabled(true);
                PcpControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            for (cond = 0; cond < 4; ++cond) {
                state = this.ps.getCondition(cond);
                PcpControlPanel.this.conditionStatus[cond].setText(state.name());
                PcpControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                PcpControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            for (int htr = 0; htr < 3; ++htr) {
                PcpHeaterState pState = this.ps.getHeaterState(htr);
                PcpControlPanel.this.htrSwitchStatus[htr].setEnabled(true);
                PcpControlPanel.this.htrSwitchStatus[htr].setText(pState.name());
                PcpControlPanel.this.htrSwitchStatus[htr].setForeground((Color)stateColors.get((Object)pState));
                selButton = PcpHeaterState.isOnState(pState) ? PcpControlPanel.this.htrSwitchOnRB[htr] : PcpControlPanel.this.htrSwitchOffRB[htr];
                selButton.setSelected(true);
                PcpControlPanel.this.htrSwitchOffRB[htr].setEnabled(true);
                PcpControlPanel.this.htrSwitchOnRB[htr].setEnabled(true);
                PcpControlPanel.this.powerTextField[htr].update((Object)this.ps.getHeaterPower(htr), true);
            }
            if (!PcpControlPanel.this.gotTempLimits && this.ps.getLimit(0) != Integer.MAX_VALUE) {
                PcpControlPanel.this.latchLabel[1].setText("Cold Temp > " + this.ps.getLimit(1) + "C:");
                PcpControlPanel.this.latchLabel[2].setText("Cold Temp < " + this.ps.getLimit(0) + "C:");
                PcpControlPanel.this.gotTempLimits = true;
            }
            PcpControlPanel.this.repaint();
        }
    }
}

