/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.bus.annotations.SkipEncoding;

@SkipEncoding
public class FileList
extends ConcurrentSkipListSet<File>
implements Serializable {
    private static final long serialVersionUID = 3543276216049016663L;
    private AtomicInteger badPixelCount = new AtomicInteger(0);

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.badPixelCount == null) {
            this.badPixelCount = new AtomicInteger(0);
        }
    }

    public File getCommonParentDirectory() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return new File("/");
        }
        File result = ((File)iterator.next()).getParentFile();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            while (!file.getAbsolutePath().startsWith(result.getAbsolutePath())) {
                result = result.getParentFile();
            }
        }
        return result;
    }

    @Override
    public String toString() {
        Path parent = this.getCommonParentDirectory().toPath();
        ArrayList<Path> relativePaths = new ArrayList<Path>();
        for (File file : this) {
            relativePaths.add(parent.relativize(file.toPath()));
        }
        String badPixels = this.badPixelCount.get() > 0 ? String.format(" (%d bad pixels)", this.badPixelCount.get()) : "";
        return String.format("%d files%s: %s %s", this.size(), badPixels, parent, relativePaths);
    }

    public void addBadPixels(int badPixels) {
        this.badPixelCount.addAndGet(badPixels);
    }

    public int getBadPixelCount() {
        return this.badPixelCount.get();
    }

    public boolean addAll(FileList fileList) {
        this.badPixelCount.addAndGet(fileList.getBadPixelCount());
        return super.addAll(fileList);
    }
}

