/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeConverter {
    private static final Logger LOG = Logger.getLogger(TypeConverter.class.getName());
    private final Map<String, String> javaToXML = new HashMap<String, String>();

    TypeConverter() {
        this.javaToXML.put("long", "long long");
        this.javaToXML.put("int", "long");
        this.javaToXML.put("boolean", "boolean");
        this.javaToXML.put("float", "float");
        this.javaToXML.put("double", "double");
        this.javaToXML.put("String", "string");
        this.javaToXML.put("java.lang.Integer", "long");
        this.javaToXML.put("java.lang.Long", "long long");
        this.javaToXML.put("java.lang.Double", "double");
        this.javaToXML.put("java.lang.Boolean", "boolean");
        this.javaToXML.put("java.lang.String", "string");
        this.javaToXML.put("java.time.Duration", "string");
    }

    String xmlType(String javaType) {
        String result;
        if (javaType.endsWith("[]")) {
            javaType = javaType.substring(0, javaType.length() - 2);
        }
        if ((result = this.javaToXML.get(javaType)) != null) {
            return result;
        }
        LOG.log(Level.WARNING, "Unknown java type {0}", javaType);
        return "string";
    }
}

