/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.HeaterConv;
import org.lsst.ccs.drivers.auxelex.HeaterPS;
import org.lsst.ccs.drivers.auxelex.TestRebBulkPS;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestHeaterPS
extends TestSrp {
    private static final double[] calDuties = new double[]{0.01, 0.03, 0.05, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.19, 0.21, 0.23, 0.25, 0.27, 0.29, 0.31, 0.33, 0.35, 0.37, 0.39, 0.41, 0.43, 0.45, 0.47, 0.49, 0.51, 0.53, 0.55, 0.67, 0.69, 0.71, 0.73, 0.75, 0.77, 0.79, 0.81, 0.83, 0.85, 0.87, 0.89, 0.91, 0.93, 0.95, 0.97, 0.99};
    protected final HeaterPS htr;

    public TestHeaterPS() {
        super(new HeaterPS());
        this.htr = (HeaterPS)this.srp;
    }

    @Command(description="Read the board temperature")
    public double readBoardTemp() throws DriverException {
        return this.htr.readBoardTemperature();
    }

    @Command(description="Set the common switch period")
    public void setSwitchPeriod(@Argument(description="Switch period") int period) throws DriverException {
        this.htr.setSwitchPeriod(period);
    }

    @Command(description="Show the common switch period")
    public int showSwitchPeriod() {
        return this.htr.getSwitchPeriod();
    }

    @Command(description="Set the duty cycle for a channel")
    public void setDutyCycle(@Argument(description="Channel number") int chan, @Argument(description="Duty cycle") double duty) throws DriverException {
        this.htr.setDutyCycle(chan, duty);
    }

    @Command(description="Show the duty cycle for a channel")
    public double showDutyCycle(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.getDutyCycle(chan);
    }

    @Command(description="Set the voltage for a channel")
    public void setVoltage(@Argument(description="Channel number") int chan, @Argument(description="Voltage") double volts) throws DriverException {
        this.htr.setVoltage(chan, volts);
    }

    @Command(description="Show the set voltage for a channel")
    public double showVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.getVoltage(chan);
    }

    @Command(description="Turn on/off a channel")
    public void setOutput(@Argument(description="Channel number") int chan, @Argument(description="State to set") TestSrp.OnOff state) throws DriverException {
        this.htr.setOutput(chan, state == TestSrp.OnOff.ON);
    }

    @Command(description="Show the state of a channel")
    public String showOutput(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.getOutput(chan) ? "on" : "off";
    }

    @Command(description="Read a channel's voltage")
    public double readVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.readVoltage(chan);
    }

    @Command(description="Read a channel's current")
    public double readCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.readCurrent(chan);
    }

    @Command(description="Show the complete power state")
    public String showPower() throws DriverException {
        StringBuilder text = new StringBuilder("Chan  State   Duty  Volts   mAmps");
        for (int chan = 0; chan < 12; ++chan) {
            text.append(String.format("\n %2s    %3s   %5.3f  %5.2f  %6.1f", chan, this.htr.getOutput(chan) ? " on" : "off", this.htr.getDutyCycle(chan), this.htr.readVoltage(chan), 1000.0 * this.htr.readCurrent(chan)));
        }
        return text.toString();
    }

    @Command(description="Generate calibration properties")
    public String calibrate(@Argument(description="Channel number") int chan, @Argument(description="Load resistance") double load) throws DriverException {
        double voltage = this.htr.readMainVoltage();
        if (voltage < 1.0) {
            throw new DriverException("Main power is off");
        }
        if (this.htr.readCurrent(chan) == 0.0) {
            throw new DriverException("No load is connected to channel " + chan);
        }
        this.htr.setDutyCycle(chan, 0.0);
        this.htr.setOutput(chan, true);
        StringBuilder text = new StringBuilder(HeaterConv.getPropName(this.htr.getIpAddress()[3], chan)).append("=1.000");
        int count = 0;
        for (double duty : calDuties) {
            this.setDutyCycle(chan, duty);
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            double vFract = this.htr.readCurrent(chan) * load / voltage;
            text.append(";");
            if (count++ % 10 == 0) {
                text.append("\\\n   ");
            }
            text.append(String.format(" %4.2f,%5.3f", duty, vFract));
            System.out.print(".");
        }
        System.out.print("\r");
        for (int j = 0; j < calDuties.length; ++j) {
            System.out.print(" ");
        }
        System.out.print("\r");
        this.htr.setDutyCycle(chan, 0.0);
        this.htr.setOutput(chan, false);
        return text.toString();
    }

    @Command(description="Show the cryo section enabled state")
    public boolean isCryoEnabled() throws DriverException {
        return this.htr.isCryoEnabled();
    }

    @Command(description="Show the cold section enabled state")
    public boolean isColdEnabled() throws DriverException {
        return this.htr.isColdEnabled();
    }

    @Command(description="Show the main model type")
    public int showMainModel() throws DriverException {
        return this.htr.getMainModel();
    }

    @Command(description="Show the main serial number")
    public String showMainSerial() throws DriverException {
        return this.htr.getMainSerialNo();
    }

    @Command(description="Show the main firmware version")
    public String showMainFwVersion() throws DriverException {
        return this.htr.getMainFwVersion();
    }

    @Command(description="Show the main product version")
    public String showMainPrVersion() throws DriverException {
        return this.htr.getMainPrVersion();
    }

    @Command(description="Show the main part number")
    public String showMainPartNo() throws DriverException {
        return this.htr.getMainPartNo();
    }

    @Command(description="Show the main manufacture date")
    public String showMainManuDate() throws DriverException {
        return this.htr.getMainManuDate();
    }

    @Command(description="Show the main manufacture location")
    public String showMainManuLocn() throws DriverException {
        return this.htr.getMainManuLocn();
    }

    @Command(description="Read the main status word")
    public String readMainStatus() throws DriverException {
        int status = this.htr.readMainStatus();
        return String.format("0x%02x %s", status, TestRebBulkPS.genBitNames(status, TestRebBulkPS.statBitsMap));
    }

    @Command(description="Read the main voltage")
    public double readMainVoltage() throws DriverException {
        return this.htr.readMainVoltage();
    }

    @Command(description="Read the main current")
    public double readMainCurrent() throws DriverException {
        return this.htr.readMainCurrent();
    }

    @Command(description="Read the main temperature")
    public double readMainTemp() throws DriverException {
        return this.htr.readMainTemperature();
    }

    @Command(description="Set the main power on or off")
    public void setMainPower(TestSrp.OnOff on) throws DriverException {
        this.htr.setMainPowerOn(on == TestSrp.OnOff.ON);
    }

    @Command(description="Show the main I/O status")
    public String showMainIoStatus() throws DriverException {
        int status = this.htr.getMainIoStatus();
        return String.format("0x%02x %s", status, TestRebBulkPS.genBitNames(status, TestRebBulkPS.ioBitsMap));
    }
}

