/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.util.Arrays;
import plotter.AbstractAxisModel;
import plotter.ContinuousAxisModel;
import plotter.DiscreteAxisModel;

public class DefaultAxisModel
extends AbstractAxisModel
implements ContinuousAxisModel,
DiscreteAxisModel {
    private static final int UNDERFLOW = -2;
    private static final int OVERFLOW = -1;
    private boolean logarithmic;
    private boolean hasOutOfRangeBins;
    private double[] binEdges;

    public DefaultAxisModel(double min, double max, int nBins, boolean logarithmic, boolean hasOutOfRangeBins) {
        this.logarithmic = logarithmic;
        this.hasOutOfRangeBins = hasOutOfRangeBins;
        this.setBins(min, max, nBins);
    }

    DefaultAxisModel(double[] binEdges, boolean logarithmic, boolean hasOutOfRangeBins) {
        this.binEdges = binEdges;
        this.logarithmic = logarithmic;
        this.hasOutOfRangeBins = hasOutOfRangeBins;
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public double[] getBinEdges() {
        return this.binEdges;
    }

    public void setBinEdges(double[] binEdges) {
        this.binEdges = binEdges;
    }

    public boolean hasOutOfRangeBins() {
        return this.hasOutOfRangeBins;
    }

    public void setHasOutOfRangeBins(boolean hasOutOfRangeBins) {
        this.hasOutOfRangeBins = hasOutOfRangeBins;
    }

    @Override
    public int getNBins() {
        return this.binEdges.length - 1 + (this.hasOutOfRangeBins ? 2 : 0);
    }

    @Override
    public int getBinFromAxisCoordinate(double axisCoordinate) {
        double model;
        int rc;
        int nBins = this.binEdges.length - 1;
        if (this.hasOutOfRangeBins) {
            double overUnderflowSize = 1.0 / (double)nBins;
            if (axisCoordinate < overUnderflowSize) {
                return -2;
            }
            if (axisCoordinate > 1.0 - overUnderflowSize) {
                return -1;
            }
        }
        if ((rc = Arrays.binarySearch(this.binEdges, model = this.getModelCoordinateFromAxisCoordinate(axisCoordinate))) < 0) {
            rc = -rc - 2;
        }
        return rc;
    }

    @Override
    public double getLowerAxisCoordinateFromBin(int bin) {
        int nBins = this.binEdges.length - 1;
        if (bin == -1) {
            return this.binEdges[nBins];
        }
        if (bin < 0 || bin >= nBins) {
            return Double.NaN;
        }
        return this.getAxisCoordinateFromModelCoordinate(this.binEdges[bin]);
    }

    @Override
    public double getUpperAxisCoordinateFromBin(int bin) {
        int nBins = this.binEdges.length - 1;
        if (bin == -2) {
            return this.binEdges[0];
        }
        if (bin < 0 || bin >= nBins) {
            return Double.NaN;
        }
        return this.getAxisCoordinateFromModelCoordinate(this.binEdges[bin + 1]);
    }

    @Override
    public double getModelCoordinateFromAxisCoordinate(double axisCoordinate) {
        int nBins = this.binEdges.length - 1;
        if (this.hasOutOfRangeBins) {
            double overUnderflowSize = 1.0 / (double)nBins;
            if (axisCoordinate < overUnderflowSize) {
                return Double.NaN;
            }
            if (axisCoordinate > 1.0 - overUnderflowSize) {
                return Double.NaN;
            }
            axisCoordinate = (axisCoordinate - overUnderflowSize) / (1.0 - 2.0 * overUnderflowSize);
        }
        double min = this.binEdges[0];
        double max = this.binEdges[nBins];
        if (this.logarithmic) {
            min = Math.log(min);
            max = Math.log(max);
            axisCoordinate = Math.exp(axisCoordinate);
        }
        return min + axisCoordinate * (max - min);
    }

    @Override
    public double getAxisCoordinateFromModelCoordinate(double modelCoordinate) {
        int nBins = this.binEdges.length - 1;
        double min = this.binEdges[0];
        double max = this.binEdges[nBins];
        if (modelCoordinate < min) {
            return Double.NaN;
        }
        if (modelCoordinate > max) {
            return Double.NaN;
        }
        if (this.logarithmic) {
            min = Math.log(min);
            max = Math.log(max);
            modelCoordinate = Math.log(modelCoordinate);
        }
        double axisCoordinate = (modelCoordinate - min) / (max - min);
        if (this.hasOutOfRangeBins) {
            double overUnderflowSize = 1.0 / (double)nBins;
            axisCoordinate = overUnderflowSize + (1.0 - 2.0 * overUnderflowSize) * axisCoordinate;
        }
        return axisCoordinate;
    }

    @Override
    public String getBinName(int bin) {
        if (bin == -2) {
            return "UNDERFLOW";
        }
        if (bin == -1) {
            return "OVERFLOW";
        }
        return "bin " + bin;
    }

    void setBins(double min, double max, int nBins) {
        this.binEdges = new double[nBins + 1];
        for (int i = 0; i <= nBins; ++i) {
            this.binEdges[i] = min + (double)i * (max - min) / (double)nBins;
        }
        this.fireAxisChanged();
    }
}

