/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceFcsGUI
extends InterfaceGeneralGUI {
    public static final long CONNECT_LOADER_TIMEOUT = 6000L;
    public static final long SET_FILTER_TIMEOUT = 120000L;
    public static final long STORE_FILTER_TIMEOUT = 60000L;
    public static final long LOAD_FILTER_TIMEOUT = 240000L;
    public static final long GRAB_FILTER_TIMEOUT = 25000L;
    public static final long DISENGAGE_FILTER_TIMEOUT = 15000L;
    public static final long TRUCKS_MOTION_TIMEOUT = 50000L;

    default public void setFilter(int filterID) {
        System.out.println("setFilter with timeout=120000");
        FCSCst.FCSLOG.info((Object)"Setting filter");
        this.sendCommand("setFilter " + filterID, 120000L);
    }

    default public void setFilterAtHandoffForLoader(int filterID) {
        System.out.println("setFilterAtHandoffForLoader with timeout=120000");
        FCSCst.FCSLOG.info((Object)"Setting filter at Handoff for Loader");
        this.sendCommand("setFilterAtHandoffForLoader " + filterID, 120000L);
    }

    default public void storeFilterOnCarousel() {
        System.out.println("storeFilterOnCarousel with timeout=60000");
        FCSCst.FCSLOG.info((Object)"Storing filter on carousel");
        this.sendCommand("storeFilterOnCarousel", 60000L);
    }

    default public void loadFilter() {
        System.out.println("loadFilter with timeout=240000");
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        this.sendCommand("loadFilter", 240000L);
    }

    default public void unloadFilter() {
        System.out.println("unloadFilter with timeout=240000");
        FCSCst.FCSLOG.info((Object)"Unloading filter in camera");
        this.sendCommand("unloadFilter", 240000L);
    }

    default public void connectLoader() {
        System.out.println("connect loader with timeout=6000");
        FCSCst.FCSLOG.info((Object)"connecting loader CANbus");
        this.sendCommand("connectLoaderCANbus", 6000L);
    }

    default public void disconnectLoader() {
        System.out.println("disconnect loader with timeout=6000");
        FCSCst.FCSLOG.info((Object)"disconnecting loader CANbus");
        this.sendCommand("disconnectLoaderCANbus", 6000L);
    }

    default public void rotateSocketToStandby(int socketID) {
        FCSCst.FCSLOG.info((Object)"Carousel rotating");
        FCSCst.FCSLOG.info((Object)"/timeout=100000");
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        this.sendCommand("rotateSocketToStandby socket" + socketID, 100000L, "carousel");
    }

    default public void grabFilterAtStandby() {
        FCSCst.FCSLOG.info((Object)"executing grabFilterAtStandby");
        this.sendCommand("grabFilterAtStandby", 25000L, "autochanger");
    }

    default public void disengageFilterFromCarousel() {
        FCSCst.FCSLOG.info((Object)"executing disengageFilterFromCarousel");
        this.sendCommand("disengageFilterFromCarousel", 15000L);
    }

    default public void moveAndClampFilterOnline() {
        FCSCst.FCSLOG.info((Object)"executing moveAndClampFilterOnline");
        FCSCst.FCSLOG.info((Object)"/timeout=50000");
        this.sendCommand("moveAndClampFilterOnline", 50000L, "autochanger");
    }
}

