/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.alert.AlertService;

public class Alarm
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Alarm.class.getName());
    private final Map<Channel, DataProviderState> currentChannelStates = new ConcurrentHashMap<Channel, DataProviderState>();
    private final Map<Channel, DataProviderState> channelStatesToBeProcessed = new ConcurrentHashMap<Channel, DataProviderState>();
    private final Map<Channel, AtomicInteger> consecutiveReadingsBelowCurrentState = new ConcurrentHashMap<Channel, AtomicInteger>();
    private final Map<Channel, String> channelCausesToBeProcessed = new ConcurrentHashMap<Channel, String>();
    public final int consecutiveValuesNeededToTriggerDownwardStateTransition = 5;
    protected String description = " ";
    private DataProviderState state = DataProviderState.NOMINAL;
    private DataProviderState oldstate = DataProviderState.NOMINAL;
    private final Object updateStateLock = new Object();
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @Deprecated
    private Alert alertToBeRaised;
    private Alert alert;

    public Alarm() {
        this(null);
    }

    public Alarm(Alert alert) {
        this.alert = this.alertToBeRaised = alert;
    }

    @Override
    public void build() {
        if (this.alertService == null) {
            throw new RuntimeException("Alarm instances must be part of the agent object tree. The AlertService instance must be non null.");
        }
        if (this.alertToBeRaised != null) {
            this.alert = this.alertToBeRaised;
        }
    }

    @Override
    public void init() {
        this.alertService.registerAlert(this.getAlert(AlertState.NOMINAL, AlertState.NOMINAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(Channel ch, DataProviderState value, String cause, boolean updateImmediately) {
        Object object = this.updateStateLock;
        synchronized (object) {
            AtomicInteger consecutiveReadings;
            DataProviderState currentChannelState = this.currentChannelStates.computeIfAbsent(ch, k -> DataProviderState.NOMINAL);
            boolean processStateTransition = updateImmediately;
            if (!processStateTransition) {
                consecutiveReadings = this.consecutiveReadingsBelowCurrentState.computeIfAbsent(ch, k -> new AtomicInteger(0));
                if (currentChannelState == null) {
                    processStateTransition = true;
                } else if (value.ordinal() > currentChannelState.ordinal()) {
                    processStateTransition = true;
                } else if (value.ordinal() < currentChannelState.ordinal()) {
                    processStateTransition = consecutiveReadings.incrementAndGet() >= 5;
                } else if (value.ordinal() == currentChannelState.ordinal()) {
                    consecutiveReadings.set(0);
                }
            }
            if (processStateTransition) {
                consecutiveReadings = this.consecutiveReadingsBelowCurrentState.computeIfAbsent(ch, k -> new AtomicInteger(0));
                consecutiveReadings.set(0);
                this.channelStatesToBeProcessed.put(ch, value);
                this.channelCausesToBeProcessed.put(ch, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            if (this.channelStatesToBeProcessed.size() > 0) {
                String alarmCause = "";
                for (Channel ch : this.channelStatesToBeProcessed.keySet()) {
                    DataProviderState channelStateToBeProcessed = this.channelStatesToBeProcessed.remove(ch);
                    String channelCauseToBeProcessed = this.channelCausesToBeProcessed.remove(ch);
                    DataProviderState currentChannelState = this.currentChannelStates.get(ch);
                    if (currentChannelState != null && currentChannelState == channelStateToBeProcessed) continue;
                    this.currentChannelStates.put(ch, channelStateToBeProcessed);
                    alarmCause = alarmCause + channelCauseToBeProcessed + "\n";
                }
                DataProviderState newState = DataProviderState.OFF_LINE;
                for (DataProviderState channelState : this.currentChannelStates.values()) {
                    if (channelState.ordinal() <= newState.ordinal()) continue;
                    newState = channelState;
                }
                if (newState != this.state && this.currentChannelStates.size() > 0) {
                    this.oldstate = this.state;
                    this.state = newState;
                    this.processAlarmTrigger(alarmCause);
                }
            }
        }
    }

    void processAlarmTrigger(String alarmCause) {
        AlertState oldAlertState;
        AlertState alertState = Alarm.getAlertState(this.getAlarmState());
        Alert a = this.getAlert(alertState, oldAlertState = Alarm.getAlertState(this.getAlarmPreviousState()));
        if (a != null) {
            LOG.log(Alarm.getLogLevel(this.getAlarmState()), "Processing \"{0}\" at level {1}.\nRaising Alert {2} with AlertState {3} caused by {4}.", new Object[]{a.getDescription(), this.getAlarmState(), a.getAlertId(), alertState, alarmCause});
            this.alertService.raiseAlert(a, alertState, alarmCause);
        } else {
            LOG.log(Level.WARNING, "Null Alert provided, so no Alert is raised.");
        }
    }

    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        if (this.alert == null) {
            return new Alert(this.name, this.getDescription());
        }
        return this.alert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void clearState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            this.state = DataProviderState.NOMINAL;
            this.currentChannelStates.clear();
        }
    }

    String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    private DataProviderState getAlarmState() {
        return this.state;
    }

    private DataProviderState getAlarmPreviousState() {
        return this.oldstate;
    }

    private static AlertState getAlertState(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return AlertState.ALARM;
            }
            case WARNING: {
                return AlertState.WARNING;
            }
            case NOMINAL: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an AlertState");
    }

    private static Level getLogLevel(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case NOMINAL: {
                return Level.INFO;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an log Level");
    }
}

