/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAccelerometer;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselBrakes;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.carousel.ui.BrakesPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselSocketTablePanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.AcceleroPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 3579024322081964467L;
    private static final Logger FCSLOG = Logger.getLogger(CarouselGeneralViewPanel.class.getName());
    private InterfaceCarouselGUI subs;
    private final String pl = "Position_";
    private final JPanel generalInfoPanel = new JPanel();
    private final JLabel profileVelocityLabel = new JLabel();
    private final JLabel profileAccelerationLabel = new JLabel();
    private final JLabel profileDecelerationLabel = new JLabel();
    private final JLabel rotationTimeoutLabel = new JLabel();
    private final JPanel actualParametersPanel = new JPanel();
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel estimatedPositionLabel = new JLabel();
    private final JLabel posLabel = new JLabel("Position: ");
    private final JLabel deltaPositionLabel = new JLabel();
    private final JLabel positionSensorTypeLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    private final JLabel powerSaveLabel = new JLabel();
    private final JPanel controllerPanel = new JPanel();
    private final DigitalSwitch controllerSwitch = new DigitalSwitch();
    private final JLabel eposStateLabel = new JLabel();
    private final JPanel controlPanel = new JPanel();
    private final JButton updatePositionButton = new JButton("Update Position");
    private final JButton rotateButton = new JButton("RotateSocketToStandby");
    private final JButton slowModeButton = new JButton("SetSlowMode");
    private final JButton fastModeButton = new JButton("SetFastMode");
    private final String[] socketList = new String[]{"        ", "Socket 1", "Socket 2", "Socket 3", "Socket 4", "Socket 5"};
    private final JComboBox<String> socketMenu = new JComboBox<String>(this.socketList);
    private final JLabel socketLabel = new JLabel("Choose destination socket: ");
    private int socketID;
    private final CarouselSocketTablePanel socketsPanel = new CarouselSocketTablePanel();
    private final AcceleroPanel acceleroPanel = new AcceleroPanel();
    private final BrakesPanel brakesPanel = new BrakesPanel();
    private final JPanel averageTemperaturePanel = new JPanel();
    private final JLabel averageTemperatureLabel = new JLabel();

    public CarouselGeneralViewPanel() {
        this.initComponents();
    }

    protected void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }

    private void setDefaultValues() {
        this.profileVelocityLabel.setText("0.0");
        this.profileAccelerationLabel.setText("0.0");
        this.profileDecelerationLabel.setText("0.0");
        this.rotationTimeoutLabel.setText("0.0");
        this.actualPositionLabel.setText("--");
        this.estimatedPositionLabel.setText("--");
        this.deltaPositionLabel.setText("--");
        this.actualSpeedLabel.setText("0.0");
        this.actualCurrentLabel.setText("0.0");
        this.standbyLabel.setText("NOT AT STANDBY position");
        this.standbySwitch.setColor(Color.gray);
        this.socketAtStandbyLabel.setText("None");
        this.filterAtStandbyLabel.setText("NO FILTER");
        this.controllerSwitch.setColor(Color.gray);
        this.eposStateLabel.setText("UNKNOWN STATE");
        this.socketMenu.setSelectedIndex(0);
        this.averageTemperatureLabel.setText("0.0");
    }

    protected void initializeGui(ConfigurationInfo configInfo) {
        this.socketsPanel.initializeGui(configInfo);
    }

    protected void update(StatusDataPublishedByCarousel s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel data:");
        SwingUtilities.invokeLater(new Update(s));
    }

    protected void update(StatusDataPublishedByCarouselBrakes s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel brakes data:");
        this.brakesPanel.update(s);
    }

    protected void update(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel controller data:");
        SwingUtilities.invokeLater(new UpdateController(s));
        this.brakesPanel.updateController(s);
    }

    protected void update(StatusDataPublishedByAccelerometer s) {
        FCSLOG.finer(() -> this.getName() + " updating from accelerometer data:");
        this.acceleroPanel.updateAccelero(s);
    }

    protected void update(StatusDataPublishedByCarouselSocket s) {
        FCSLOG.finer(() -> this.getName() + " updating from socket data:");
        this.socketsPanel.updateSocket(s);
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    private void initComponents() {
        this.setName("carouselGeneralViewPanel");
        this.updatePositionButton.addActionListener(evt -> this.updatePositionButtonActionPerformed(evt));
        this.slowModeButton.addActionListener(evt -> this.slowModeButtonActionPerformed(evt));
        this.fastModeButton.addActionListener(evt -> this.fastModeButtonActionPerformed(evt));
        this.rotateButton.addActionListener(evt -> this.rotateButtonActionPerformed(evt));
        this.setDefaultValues();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Information"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.generalInfoPanel.add((Component)new JLabel("ProfileVelocity:"), gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)new JLabel("ProfileAcceleration:"), gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)new JLabel("ProfileDeceleration:"), gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)new JLabel("RotationTimeout:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        this.generalInfoPanel.add((Component)this.profileVelocityLabel, gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)this.profileAccelerationLabel, gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)this.profileDecelerationLabel, gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)this.rotationTimeoutLabel, gbc);
        this.actualParametersPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.actualParametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.actualParametersPanel.add((Component)this.posLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Estimated Position: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Delta Position: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("P. Sensor Type: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Speed: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Current: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("PowerSave: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Socket at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Filter at STANDBY: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.actualParametersPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.estimatedPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.deltaPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.positionSensorTypeLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualSpeedLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualCurrentLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.powerSaveLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.actualParametersPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.socketAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.filterAtStandbyLabel, gbc1);
        this.controllerPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.controllerPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.controllerPanel.add((Component)new JLabel("Controller status :"), gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        this.controllerSwitch.setSize(40);
        gbc.gridheight = 2;
        this.controllerPanel.add((Component)this.controllerSwitch, gbc);
        gbc.gridheight = 1;
        ++gbc.gridx;
        ++gbc.gridy;
        this.controllerPanel.add((Component)this.eposStateLabel, gbc);
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.gridwidth = 2;
        this.controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.slowModeButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.fastModeButton, gbc4);
        ++gbc4.gridy;
        gbc4.anchor = 13;
        gbc4.gridwidth = 1;
        this.controlPanel.add((Component)this.socketLabel, gbc4);
        ++gbc4.gridx;
        gbc4.anchor = 17;
        gbc4.fill = 0;
        this.controlPanel.add(this.socketMenu, gbc4);
        ++gbc4.gridy;
        gbc4.gridx = 0;
        gbc4.gridwidth = 2;
        gbc4.fill = 2;
        gbc4.anchor = 23;
        this.controlPanel.add((Component)this.rotateButton, gbc4);
        this.averageTemperaturePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        this.averageTemperaturePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.NICE_PINK), "Clamps Temperature"));
        gbc.insets = Tools.insets_std;
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.averageTemperaturePanel.add((Component)new JLabel("Average clamps temperature in mV:"), gbc);
        ++gbc.gridx;
        gbc1.anchor = 22;
        this.averageTemperaturePanel.add((Component)this.averageTemperatureLabel, gbc);
        this.setBorder(Tools.getGeneralPanelTitle("Carousel Overview"));
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controllerPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.actualParametersPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.socketsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.brakesPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.averageTemperaturePanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.acceleroPanel, gbc);
    }

    private void updatePositionButtonActionPerformed(ActionEvent evt) {
        this.subs.updatePosition();
    }

    private void slowModeButtonActionPerformed(ActionEvent evt) {
        this.subs.setSlowMode();
    }

    private void fastModeButtonActionPerformed(ActionEvent evt) {
        this.subs.setFastMode();
    }

    private void rotateButtonActionPerformed(ActionEvent evt) {
        int selectedSocketNb = this.socketMenu.getSelectedIndex();
        if (selectedSocketNb != 0) {
            this.socketID = selectedSocketNb;
            this.subs.rotate(this.socketID);
            this.socketMenu.setSelectedIndex(0);
        }
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.socketsPanel.resetPanel();
        this.acceleroPanel.resetPanel();
        this.brakesPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "Overview";
    }

    public static void main(String[] argv) {
        CarouselGeneralViewPanel d = new CarouselGeneralViewPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class Update
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            String sensorType;
            CarouselGeneralViewPanel.this.actualPositionLabel.setText(Integer.toString(this.s.getPosition()));
            switch (this.s.getPositionSensorType() & 0xF) {
                case 4: {
                    sensorType = "Ssi";
                    CarouselGeneralViewPanel.this.estimatedPositionLabel.setText("--");
                    break;
                }
                case 8: {
                    sensorType = "Inc";
                    CarouselGeneralViewPanel.this.estimatedPositionLabel.setText(Integer.toString(this.s.getEstimatedPosition()));
                    break;
                }
                default: {
                    sensorType = Integer.toString(this.s.getPositionSensorType());
                    CarouselGeneralViewPanel.this.estimatedPositionLabel.setText("--");
                }
            }
            CarouselGeneralViewPanel.this.positionSensorTypeLabel.setText(sensorType);
            CarouselGeneralViewPanel.this.posLabel.setText("Position_" + sensorType);
            CarouselGeneralViewPanel.this.rotationTimeoutLabel.setText(Long.toString(this.s.getRotationTimeout()));
            CarouselGeneralViewPanel.this.averageTemperatureLabel.setText(Long.toString(this.s.getMeanClampsTemperature()));
            if (this.s.isAtStandby() && !this.s.isMoving()) {
                CarouselGeneralViewPanel.this.deltaPositionLabel.setText(Integer.toString(this.s.getDeltaPositionAtStandby()));
                CarouselGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                if (this.s.isEmptyAtStandby()) {
                    CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName());
                } else {
                    CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName() + "/" + this.s.getFilterAtStandbyId());
                }
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
            } else {
                CarouselGeneralViewPanel.this.deltaPositionLabel.setText("--");
                CarouselGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Color.orange);
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText("--");
                if (this.s.isMoving()) {
                    CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText("--");
                } else {
                    CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                }
            }
        }
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                CarouselGeneralViewPanel.this.eposStateLabel.setText(this.s.getState().name());
                CarouselGeneralViewPanel.this.controllerSwitch.setColor(this.s.getState().getColor());
                CarouselGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getVelocity()));
                CarouselGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getCurrent()));
                CarouselGeneralViewPanel.this.profileVelocityLabel.setText(Long.toString(this.s.getProfileVelocity()));
                CarouselGeneralViewPanel.this.profileAccelerationLabel.setText(Long.toString(this.s.getProfileAcceleration()));
                CarouselGeneralViewPanel.this.profileDecelerationLabel.setText(Long.toString(this.s.getProfileDeceleration()));
            } else if (!this.s.isBooted()) {
                CarouselGeneralViewPanel.this.eposStateLabel.setText("not booted");
                CarouselGeneralViewPanel.this.controllerSwitch.setColor(Color.RED);
            }
        }
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            if (this.sensorMap.containsKey("powerSave")) {
                boolean power_save;
                boolean bl = power_save = (Integer)this.sensorMap.get("powerSave") == 1;
                if (power_save) {
                    CarouselGeneralViewPanel.this.powerSaveLabel.setText("ON");
                } else {
                    CarouselGeneralViewPanel.this.powerSaveLabel.setText("OFF");
                }
            }
        }
    }
}

