/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bus.bot;

import java.io.PrintWriter;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroEndSession;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroRunSamplingScan;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroSetTransform;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroStartSession;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroTakeSamplesAt;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroWait;

public class MetroCommandPrinter
implements MetroCommandListener {
    private final PrintWriter writer;

    public MetroCommandPrinter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void metroWait(MetroWait cmd) {
        this.writer.format("%-15s %g%n", "WAIT", cmd.getSeconds());
    }

    @Override
    public void metroSetTransform(MetroSetTransform cmd) {
        this.writer.format("%-15s X0=%g, Y0=%g, THETA=%g%n", "TRANSFORM", cmd.getX0(), cmd.getX0(), cmd.getTheta());
    }

    @Override
    public void metroRunSamplingScan(MetroRunSamplingScan cmd) {
        this.writer.format("%-15s X0=%g, Y0=%g, X1=%g, Y1=%g, N=%d, DC=%g, label=%s%n", "SAMPLE LINE", cmd.getXStart(), cmd.getYStart(), cmd.getXFinish(), cmd.getYFinish(), cmd.getNumSamples(), cmd.getDutyCycle(), cmd.getLabel());
    }

    @Override
    public void metroTakeSamplesAt(MetroTakeSamplesAt cmd) {
        this.writer.format("%-15s X=%g, Y=%g, N=%d, label=%s%n", "SAMPLE POINT", cmd.getXCoord(), cmd.getYCoord(), cmd.getNumSamples(), cmd.getLabel());
    }

    @Override
    public void metroEndSession(MetroEndSession cmd) {
        this.writer.format("%-15s%n", "END SESSION");
    }

    @Override
    public void metroStartSession(MetroStartSession cmd) {
        this.writer.format("%-15s file=%s%n", "START SESSION", cmd.getFilename());
    }
}

