/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.TypeConverter;
import org.lsst.ccs.camera.sal.xml.UnitConverter;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLMaker2 {
    private final boolean verbose;
    private final UnitConverter unitConverter = new UnitConverter();
    private final TypeConverter typeConverter = new TypeConverter();
    private static final Logger LOG = Logger.getLogger(XMLMaker2.class.getName());

    public XMLMaker2(boolean verbose) {
        this.verbose = verbose;
    }

    public Document createXML(MakeXMLConfiguration config) throws ParserConfigurationException, TransformerException {
        Document document = this.createDocument(config.getSALType());
        List<MakeXMLConfiguration.DictionaryConfiguration> dictConfigs = config.getOrderedListOfDictionaryConfigurations();
        for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : dictConfigs) {
            SALClassDescriptionMaker descriptionMaker = new SALClassDescriptionMaker(dictConfig, config.getMapping());
            this.generateXML(document, descriptionMaker);
        }
        return document;
    }

    public Document createDocument(SALType salType) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Element rootEle = dom.createElement("SAL" + salType.getSchema() + "Set");
        rootEle.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "https://raw.githubusercontent.com/lsst-ts/ts_xml/develop/python/lsst/ts/xml/data/schema/SAL" + salType.getSchema() + "Set.xsd");
        dom.appendChild(rootEle);
        return dom;
    }

    public void addXML(Document document, MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping) throws IOException, ParserConfigurationException, TransformerException, ClassNotFoundException {
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(dictConfig, mapping);
        this.generateXML(document, infoMaker);
    }

    public Document makeXMLFromDictionary(MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping) throws ParserConfigurationException, TransformerException, ClassNotFoundException, IOException {
        return this.makeXMLFromDictionary(dictConfig, mapping, dictConfig.getLevel());
    }

    public Document makeXMLFromDictionary(MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping, int level) throws ParserConfigurationException, TransformerException, ClassNotFoundException, IOException {
        SALType type = dictConfig.getSALType();
        Document document = this.createDocument(type);
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(dictConfig, mapping, level);
        this.generateXML(document, infoMaker);
        return document;
    }

    public void generateXML(Document dom, SALClassDescriptionMaker descMaker) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        this.generateXML(dom, descMaker, descMaker.getLevel());
    }

    public void generateXML(Document dom, SALClassDescriptionMaker descMaker, int level) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        SALType salType = descMaker.getDictionaryConfiguration().getSALType();
        Map<String, SALClassDescription> salClassDescriptions = descMaker.getSALClassDescriptions();
        String subsystemName = descMaker.getDictionaryConfiguration().getCSCName();
        Element rootEle = (Element)dom.getChildNodes().item(0);
        String classNameAppendage = salType.getClassNameAppendage();
        if (this.verbose) {
            for (Map.Entry<String, SALClassDescription> key : salClassDescriptions.entrySet()) {
                System.out.println(" Class Name " + key.getKey());
                System.out.println(key.getValue());
            }
        }
        StringBuilder summaryOfMissingDescriptions = new StringBuilder("Topics with missing descriptions:\n");
        boolean missingDescriptions = false;
        StringBuilder summaryOfMissingUnits = new StringBuilder("Topics with missing units:\n");
        boolean missingUnits = false;
        for (Map.Entry<String, SALClassDescription> entry : salClassDescriptions.entrySet()) {
            Object type;
            if (subsystemName.contains("comcam")) {
                subsystemName = "CCCamera";
            }
            String topicName = entry.getValue().getTopicName();
            topicName = topicName + classNameAppendage;
            String text = "Created by xmlmaker2 for subsystem " + subsystemName + " class " + topicName + " using level " + level;
            String category = entry.getValue().getCategory();
            if (category != null && !category.isEmpty()) {
                text = text + " for category " + category;
            }
            Comment comment = dom.createComment(text);
            rootEle.appendChild(comment);
            Comment comment2 = dom.createComment(String.join((CharSequence)"", Collections.nCopies(text.length(), "=")));
            rootEle.appendChild(comment2);
            Element salElement = dom.createElement("SAL" + salType.getSchema());
            rootEle.appendChild(salElement);
            Element subsystemElement = dom.createElement("Subsystem");
            subsystemElement.setTextContent(subsystemName);
            salElement.appendChild(subsystemElement);
            Element topicElement = dom.createElement("EFDB_Topic");
            topicElement.setTextContent(topicName);
            salElement.appendChild(topicElement);
            String checksumText = "CCS: Dictionary_Checksum: " + Long.toString(entry.getValue().computeChecksum()) + "L ";
            Comment checksumComment = dom.createComment(checksumText);
            salElement.appendChild(checksumComment);
            if (classNameAppendage.contains("Configuration")) {
                Element version = dom.createElement("item");
                salElement.appendChild(version);
                Element efdbName = dom.createElement("EFDB_Name");
                efdbName.setTextContent("version");
                version.appendChild(efdbName);
                Element desc = dom.createElement("Description");
                desc.setTextContent("Version of the settings, formatted using CCS conventions");
                version.appendChild(desc);
                type = dom.createElement("IDL_Type");
                type.setTextContent("string");
                version.appendChild((Node)type);
                Element units = dom.createElement("Units");
                units.setTextContent("unitless");
                version.appendChild(units);
                Element count = dom.createElement("Count");
                count.setTextContent("1");
                version.appendChild(count);
            }
            for (SALClassDescription.SALVariable var : entry.getValue().getVariables()) {
                String salUnits;
                boolean isStringArray;
                int counts = entry.getValue().getSharedLocationCount(var);
                type = this.typeConverter.xmlType(var.getType());
                String variableName = var.getVariableName();
                if (variableName.contains("_")) {
                    String temp = "";
                    String[] splitVariable = variableName.split("_");
                    splitVariable[0] = splitVariable[0].toLowerCase();
                    for (int i = 0; i <= splitVariable.length - 1; ++i) {
                        temp = temp + splitVariable[i] + "_";
                    }
                    if (temp.charAt(temp.length() - 1) == '_') {
                        temp = temp.substring(0, temp.length() - 1);
                    }
                    variableName = temp;
                } else {
                    variableName = variableName.length() > 1 ? variableName.substring(0, 1).toLowerCase() + variableName.substring(1) : variableName.toLowerCase();
                }
                variableName = variableName.replace('-', '_');
                if (Character.isDigit(variableName.charAt(0))) {
                    variableName = "n_" + variableName;
                }
                if (var instanceof SALClassDescription.PatternMatchedSALVariable) {
                    SALClassDescription.PatternMatchedSALVariable pmsv = (SALClassDescription.PatternMatchedSALVariable)var;
                    SALClassDescription.LocationVariable locationVariable = pmsv.getLocationVariable();
                    Comment locationComment = dom.createComment("CCSMETA: Array " + variableName + " indexed by " + locationVariable.getVariableName());
                    salElement.appendChild(locationComment);
                }
                String description = null;
                if (var.getDescription() == null) {
                    description = "MISSING";
                    summaryOfMissingDescriptions.append("M.D. ").append(topicName).append("_").append(variableName).append("\n");
                    missingDescriptions = true;
                } else {
                    description = var.getDescription();
                }
                int backslash = description.indexOf(92);
                if (backslash > 0) {
                    description = description.substring(backslash + 1);
                }
                Element item = dom.createElement("item");
                salElement.appendChild(item);
                Element efdbName = dom.createElement("EFDB_Name");
                efdbName.setTextContent(variableName);
                item.appendChild(efdbName);
                boolean bl = isStringArray = counts > 1 && "string".equals(type);
                if (isStringArray) {
                    description = description + " (colon delimited array)";
                }
                Element desc = dom.createElement("Description");
                desc.setTextContent(description);
                item.appendChild(desc);
                Element idlType = dom.createElement("IDL_Type");
                idlType.setTextContent((String)type);
                item.appendChild(idlType);
                String ccsUnits = var.getUnits();
                if (ccsUnits == null || ccsUnits.isEmpty()) {
                    summaryOfMissingUnits.append("M.U. ").append(topicName).append("_").append(variableName).append("\n");
                    missingUnits = true;
                }
                if ("unitless".equals(salUnits = this.unitConverter.convertCCSUnitToSALUnit(ccsUnits)) && variableName.endsWith("taskPeriodMillis")) {
                    salUnits = "millisecond";
                }
                if ("string".equals(type) && !"unitless".equals(salUnits)) {
                    salUnits = "unitless";
                }
                Element unitsElement = dom.createElement("Units");
                unitsElement.setTextContent(salUnits);
                item.appendChild(unitsElement);
                Element countElement = dom.createElement("Count");
                countElement.setTextContent(String.valueOf(isStringArray ? 1 : counts));
                item.appendChild(countElement);
                if (!(var instanceof SALClassDescription.PatternMatchedSALVariable) || counts != 1) continue;
                Element isJavaArray = dom.createElement("IsJavaArray");
                isJavaArray.setTextContent("yes");
                item.appendChild(isJavaArray);
            }
        }
        if (missingDescriptions) {
            LOG.log(Level.WARNING, "Missing descriptions\n {0}", summaryOfMissingDescriptions.toString());
        }
        if (missingUnits) {
            LOG.log(Level.WARNING, "Missing units\n {0}", summaryOfMissingUnits.toString());
        }
    }

    private String cleanCapitalize(String inString) {
        String output = inString;
        output = output.toLowerCase();
        output = output.substring(0, 1).toUpperCase() + output.substring(1);
        output = output.trim();
        return output;
    }

    public void writeXML(StreamResult output, Document dom) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer tr = transformerFactory.newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.transform(new DOMSource(dom), output);
    }

    public static enum SALType {
        TELEMETRY("Telemetry", "_Telemetry.xml"),
        SETTINGS_APPLIED("Event", "_Events.xml");

        private final String type;
        private final String xmlFileSuffix;

        private SALType(String type, String xmlFileSuffix) {
            this.type = type;
            this.xmlFileSuffix = xmlFileSuffix;
        }

        String getSchema() {
            return this.type;
        }

        public String getXMLFileSuffix() {
            return this.xmlFileSuffix;
        }

        public String getClassNameAppendage() {
            return this == SETTINGS_APPLIED ? "Configuration" : "";
        }
    }
}

