/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;

public class MotorCommandSender
implements MotorCommandListener,
TargetStatusListener {
    private static final Logger LOG = Logger.getLogger(MotorCommandSender.class.getName());
    private final AgentMessagingLayer messaging;
    private final CommandOriginator origin;
    private String target;

    public MotorCommandSender(AgentMessagingLayer messaging, CommandOriginator origin) {
        this.messaging = messaging;
        this.origin = origin;
        this.target = "";
    }

    public void setTarget(String target) {
        this.target = target;
    }

    private CommandRequest makeCommandRequest(Object cmd) {
        String cmdClassName = cmd.getClass().getSimpleName();
        String cmdName = cmdClassName.substring(0, 1).toLowerCase() + cmdClassName.substring(1);
        LOG.log(Level.INFO, "Command name is {0}", cmdName);
        return new CommandRequest(this.target, cmdName, new Object[]{cmd});
    }

    @Override
    public void changeAxisEnable(ChangeAxisEnable cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void changeOutputLine(ChangeOutputLine cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void clearAllFaults(ClearAllFaults cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void clearAxisFaults(ClearAxisFaults cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void clearCapture(ClearCapture cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void enableAllAxes(EnableAllAxes cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void homeAxis(HomeAxis cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void sendConfiguration(SendConfiguration cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void setupCapture(SetupCapture cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void stopAllMotion(StopAllMotion cmd) {
        this.messaging.sendCommandRequest(this.makeCommandRequest(cmd), this.origin);
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        this.target = evt.getTargetSubsystem();
    }
}

