/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Clock;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Constant;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerConfig;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerRoutines;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

abstract class AbstractVisitor
implements Visitor {
    @Override
    public void visit(Sequencer s) {
        s.getSequencerConfig().accept(this);
        s.getSequencerRoutines().accept(this);
    }

    @Override
    public void visit(SequencerConfig s) {
        for (Parameter p : s.getParameters()) {
            p.accept(this);
        }
        for (Channel c : s.getChannels()) {
            c.accept(this);
        }
        for (FunctionPointer fp : s.getFuncPtrs()) {
            fp.accept(this);
        }
        for (RepeatFunctionPointer rfp : s.getFuncRepPtrs()) {
            rfp.accept(this);
        }
        for (SubroutinePointer sp : s.getSubPtrs()) {
            sp.accept(this);
        }
        for (RepeatSubroutinePointer rsp : s.getSubRepPtrs()) {
            rsp.accept(this);
        }
        for (Function f : s.getFunctions()) {
            f.accept(this);
        }
    }

    @Override
    public void visit(SequencerRoutines s) {
        for (Subroutine subroutine : s.getSubroutines()) {
            subroutine.accept(this);
        }
        for (Main main : s.getMains()) {
            main.accept(this);
        }
    }

    @Override
    public void visit(Function f) {
        for (Constant constant : f.getConstants()) {
            constant.accept(this);
        }
        for (Clock clock : f.getClocks()) {
            clock.accept(this);
        }
        for (Timeslice timeslice : f.getTimeslices()) {
            timeslice.accept(this);
        }
    }

    @Override
    public void visit(Subroutine s) {
        for (Call c : s.getCalls()) {
            c.accept(this);
        }
    }

    @Override
    public void visit(Main s) {
        for (Call c : s.getCalls()) {
            c.accept(this);
        }
    }

    @Override
    public void visit(Call c) {
        if (c.getFunction() == null && c.getSubroutine() == null && c.getFunctionPointer() == null && c.getSubroutinePointer() == null && c.getCalls() == null) {
            throw new RuntimeException("call " + c + " has no function/subroutine/embedded calls");
        }
        if (c.getCalls() != null) {
            for (Call cc : c.getCalls()) {
                cc.accept(this);
            }
        }
    }
}

