/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class PLCAutochangerPanel
extends JPanel {
    private final String engineering = "<BR>Autochanger<BR>Engineering<BR>Mode";
    private final String lockout = "Autochanger<BR>Lock Out Bay M";
    private final String lockoutShunt = "<BR>Autochanger<BR>Lock Out Shunt Bay M";
    private final String enable_clamps = "enable_clamps";
    private final String enable_latches = "enable_latches";
    private final String enable_rails = "enable_linear_rails";
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1SwitchL1 = new DigitalSwitch();
    private final DigitalSwitch af1SwitchL2 = new DigitalSwitch();
    private final DigitalSwitch af3SwitchC = new DigitalSwitch();
    private final DigitalSwitch af3SwitchR1 = new DigitalSwitch();
    private final DigitalSwitch af3SwitchR4 = new DigitalSwitch();
    private final DigitalSwitch ap1SwitchC = new DigitalSwitch();
    private final DigitalSwitch ap1SwitchR = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3SwitchC = new DigitalSwitch();
    private final DigitalSwitch ap3SwitchR = new DigitalSwitch();
    private final DigitalSwitch notAp3Switch = new DigitalSwitch();
    private final DigitalSwitch ainSwitchC = new DigitalSwitch();
    private final DigitalSwitch ainSwitchL = new DigitalSwitch();
    private final DigitalSwitch ainSwitchR = new DigitalSwitch();
    private final DigitalSwitch notAlmSwitch = new DigitalSwitch();
    private final DigitalSwitch aolSwitch = new DigitalSwitch();
    private final DigitalSwitch cfcSwitch = new DigitalSwitch();
    private final DigitalSwitch cf0Switch1 = new DigitalSwitch();
    private final DigitalSwitch cf0Switch2 = new DigitalSwitch();
    private final DigitalSwitch cf1Switch = new DigitalSwitch();
    private final DigitalSwitch csSwitch1 = new DigitalSwitch();
    private final DigitalSwitch csSwitch2 = new DigitalSwitch();
    private final DigitalSwitch csSwitch3 = new DigitalSwitch();
    private final DigitalSwitch csSwitch4 = new DigitalSwitch();
    private final DigitalSwitch lpsSwitch = new DigitalSwitch();
    private final DigitalSwitch lrhSwitch = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitchC = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitchL = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitchR = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitchC = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitchL = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitchR = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchC = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchL = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchR = new DigitalSwitch();
    private final RectangleSwitch clampsRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch latchesRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch railsRelayRectangle = new RectangleSwitch();

    public PLCAutochangerPanel() {
        this.initComponents();
    }

    public void updateAutochanger(StatusDataPublishedByAutoChanger status) {
        SwingUtilities.invokeLater(new UpdateAutochanger(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("AUTOCHANGER PROTECTION SYSTEM"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        ++gbc.gridy;
        this.add((Component)this.create_explanationsPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_clampsPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_latchesPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_linearRailsPanel(), gbc);
        this.setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)new JLabel("<HTML><b>Signals displayed on this panel are read on acSensorsGateway (Autochanger PLC)</b></HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP1</b>: autochanger at STANDBY position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP3</b>: autochanger at ONLINE position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AOL</b>: ONLINE clamps all opened &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF0</b>: autochanger latches opened</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF1</b>: filter engaged on autochanger</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF3</b>: filter engaged and locked on autochanger  &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel(""), gbcp);
        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add((Component)new JLabel("<HTML><b>CS</b>: carousel stopped at STANDBY position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CFC</b>: filter LOCKED on carousel</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CF0</b>: no filter on carousel at STANDBY</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>CF1</b>: filter on carousel at STANDBY</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LRH</b>: Loader holding filter at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LPS</b>: Loader carrier at STORAGE position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>ALM</b>: Loader docked</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AIN</b>: Inclinaison sensor less than 10\u00b0</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel(""), gbcp);
        return panel;
    }

    private JPanel create_clampsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Online Clamps"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP3", this.ap3SwitchC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3SwitchC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AIN", this.ainSwitchC, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("Autochanger<BR>Lock Out Bay M", this.lockoutSwitchC, "<BR>Autochanger<BR>Lock Out Shunt Bay M", this.lockoutShuntSwitchC), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("enable_clamps", this.clampsRelayRectangle, false, false), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("<BR>Autochanger<BR>Engineering<BR>Mode", this.engineeringSwitchC, false, true, 100), gbcp);
        return panel;
    }

    private JPanel create_latchesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Latches"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP2", this.ap2Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF1", this.af1SwitchL1, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("LRH", this.lrhSwitch, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AIN", this.ainSwitchL, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 3;
        panel.add((Component)new VerticalLine(175, 50), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("Autochanger<BR>Lock Out Bay M", this.lockoutSwitchL, "<BR>Autochanger<BR>Lock Out Shunt Bay M", this.lockoutShuntSwitchL), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("enable_latches", this.latchesRelayRectangle, false, false), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CFC", this.cfcSwitch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP1", this.ap1SwitchC, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF1", this.af1SwitchL2, false, true), gbcp);
        gbcp.gridx = 0;
        ++gbcp.gridy;
        gbcp.gridwidth = 5;
        panel.add((Component)Tools.createPanelWithComponent("<BR>Autochanger<BR>Engineering<BR>Mode", this.engineeringSwitchL, false, true, 230), gbcp);
        return panel;
    }

    private JPanel create_linearRailsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Linear Rails"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch1, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 2;
        panel.add((Component)Tools.createPanelWithComponent("CF0", this.cf0Switch1, false, true, 100), gbcp);
        gbcp.gridwidth = 1;
        ++gbcp.gridx;
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 10), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3SwitchR1, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NOT AP3", this.notAp3Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AOL", this.aolSwitch, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 3;
        panel.add((Component)new VerticalLine(130, 45), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("LPS", this.lpsSwitch, "<BR>NOT ALM</BR>", this.notAlmSwitch), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 4;
        panel.add((Component)new VerticalLine(180, 50), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)Tools.createPanelWithComponent("AIN", this.ainSwitchR, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 5;
        panel.add((Component)new VerticalLine(260, 50), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.create_subPanelWith2Switch("Autochanger<BR>Lock Out Bay M", this.lockoutSwitchR, "<BR>Autochanger<BR>Lock Out Shunt Bay M", this.lockoutShuntSwitchR), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("enable_linear_rails", this.railsRelayRectangle, false, false), gbcp);
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch2, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("CF1", this.cf1Switch, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP1", this.ap1SwitchR, false, true), gbcp);
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch3, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 6;
        gbcp.anchor = 17;
        panel.add((Component)Tools.createPanelWithComponent("AF0", this.af0Switch, false, true, 375), gbcp);
        gbcp.gridwidth = 1;
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        panel.add((Component)Tools.createPanelWithComponent("CS", this.csSwitch4, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("CF0", this.cf0Switch2, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("AP3", this.ap3SwitchR, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 8;
        panel.add((Component)Tools.createPanelWithComponent("AF3", this.af3SwitchR4, false, true, 500), gbcp);
        gbcp.gridwidth = 1;
        gbcp.gridx = 0;
        ++gbcp.gridy;
        gbcp.gridwidth = 13;
        panel.add((Component)Tools.createPanelWithComponent("<BR>Autochanger<BR>Engineering<BR>Mode", this.engineeringSwitchR, false, true, 750), gbcp);
        return panel;
    }

    private void setDefaultValues() {
        DigitalSwitch[] digitalList;
        for (DigitalSwitch c : digitalList = new DigitalSwitch[]{this.af0Switch, this.af1SwitchL1, this.af1SwitchL2, this.af3SwitchC, this.af3SwitchR1, this.af3SwitchR4, this.ap1SwitchC, this.ap1SwitchR, this.ap2Switch, this.ap3SwitchC, this.ap3SwitchR, this.notAp3Switch, this.ainSwitchC, this.ainSwitchL, this.ainSwitchR, this.notAlmSwitch, this.aolSwitch, this.cfcSwitch, this.cf0Switch1, this.cf0Switch2, this.cf1Switch, this.csSwitch1, this.csSwitch2, this.csSwitch3, this.csSwitch4, this.lpsSwitch, this.lrhSwitch, this.lockoutSwitchC, this.lockoutSwitchL, this.lockoutSwitchR, this.lockoutShuntSwitchC, this.lockoutShuntSwitchL, this.lockoutShuntSwitchR, this.engineeringSwitchC, this.engineeringSwitchL, this.engineeringSwitchR}) {
            c.setColor(Color.gray);
        }
        this.clampsRelayRectangle.setColor(Color.gray);
        this.latchesRelayRectangle.setColor(Color.gray);
        this.railsRelayRectangle.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Autochanger Panel";
    }

    private class UpdateAutochanger
    implements Runnable {
        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCAutochangerPanel.this.lpsSwitch.updateColor(this.s.isLoaderConnectedSensorsInError(), this.s.getLoaderConnectedSensorValue());
            PLCAutochangerPanel.this.lrhSwitch.updateColor(false, this.s.isLoaderHoldingFilterAtHandoff());
            PLCAutochangerPanel.this.notAlmSwitch.updateColor(this.s.isLoaderPresenceInError(), !this.s.isLoaderPresence());
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCAutochangerPanel.this.ainSwitchC, PLCAutochangerPanel.this.ainSwitchL, PLCAutochangerPanel.this.ainSwitchR}) {
                ds.setColor(this.s.isOUT_AIN() ? Color.GREEN : Color.gray);
            }
            PLCAutochangerPanel.this.aolSwitch.setColor(this.s.isOUT_AOL() ? Color.GREEN : Color.gray);
            PLCAutochangerPanel.this.cfcSwitch.updateColor(this.s.isCarouselHoldingFilterInError(), this.s.isCarouselHoldingFilter());
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCAutochangerPanel.this.csSwitch1, PLCAutochangerPanel.this.csSwitch2, PLCAutochangerPanel.this.csSwitch3, PLCAutochangerPanel.this.csSwitch4}) {
                ds.updateColor(this.s.isCarousel_CS_InError(), this.s.isCarousel_CS());
            }
            PLCAutochangerPanel.this.cf0Switch1.updateColor(this.s.isCarousel_CF0_InError(), this.s.isCarousel_CF0());
            PLCAutochangerPanel.this.cf0Switch2.updateColor(this.s.isCarousel_CF0_InError(), this.s.isCarousel_CF0());
            PLCAutochangerPanel.this.cf1Switch.updateColor(this.s.isCarousel_CF1_InError(), this.s.isCarousel_CF1());
            PLCAutochangerPanel.this.railsRelayRectangle.updateColor(false, this.s.isEnableRailLin1());
            PLCAutochangerPanel.this.railsRelayRectangle.updateColor(false, this.s.isEnableRailLin2());
            PLCAutochangerPanel.this.clampsRelayRectangle.updateColor(false, this.s.isEnableClamps());
            PLCAutochangerPanel.this.latchesRelayRectangle.updateColor(false, this.s.isEnableLatches());
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCAutochangerPanel.this.engineeringSwitchC, PLCAutochangerPanel.this.engineeringSwitchL, PLCAutochangerPanel.this.engineeringSwitchR}) {
                ds.updateColor(this.s.isEngineeringKey_InError(), this.s.isEngineeringKey());
            }
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCAutochangerPanel.this.lockoutSwitchC, PLCAutochangerPanel.this.lockoutSwitchL, PLCAutochangerPanel.this.lockoutSwitchR}) {
                ds.updateColor(this.s.isLockOutInError(), this.s.isLockOut());
            }
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCAutochangerPanel.this.lockoutShuntSwitchC, PLCAutochangerPanel.this.lockoutShuntSwitchL, PLCAutochangerPanel.this.lockoutShuntSwitchR}) {
                ds.setColor(this.s.isLockOutShunt() ? Color.GREEN : Color.gray);
            }
            PLCAutochangerPanel.this.ap1SwitchC.updateColor(this.s.isOUT_AP1_InError(), this.s.isOUT_AP1());
            PLCAutochangerPanel.this.ap1SwitchR.updateColor(this.s.isOUT_AP1_InError(), this.s.isOUT_AP1());
            PLCAutochangerPanel.this.ap2Switch.updateColor(this.s.isOUT_AP2_InError(), this.s.isOUT_AP2());
            PLCAutochangerPanel.this.ap3SwitchC.updateColor(this.s.isOUT_AP3_InError(), this.s.isOUT_AP3());
            PLCAutochangerPanel.this.ap3SwitchR.updateColor(this.s.isOUT_AP3_InError(), this.s.isOUT_AP3());
            PLCAutochangerPanel.this.notAp3Switch.updateColor(this.s.isOUT_AP3_InError(), !this.s.isOUT_AP3());
            PLCAutochangerPanel.this.af0Switch.updateColor(this.s.isOUT_AF0_InError(), this.s.isOUT_AF0());
            PLCAutochangerPanel.this.af1SwitchL1.updateColor(this.s.isOUT_AF1_InError(), this.s.isOUT_AF1());
            PLCAutochangerPanel.this.af1SwitchL2.updateColor(this.s.isOUT_AF1_InError(), this.s.isOUT_AF1());
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCAutochangerPanel.this.af3SwitchC, PLCAutochangerPanel.this.af3SwitchR1, PLCAutochangerPanel.this.af3SwitchR4}) {
                ds.updateColor(this.s.isOUT_AF3_InError(), this.s.isOUT_AF3());
            }
        }
    }
}

