/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.camera.sal.xml.Mapping;

public class MappingTest {
    private Mapping mapping;

    @Before
    public void setup() {
        this.mapping = Mapping.defaultMapping();
        Assert.assertEquals((long)12L, (long)this.mapping.getPatternList().size());
    }

    @Test
    public void testLegacy() {
        Mapping.Match match = this.mapping.match("R22/Reb0/xyz");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"xyz", (Object)match.getPathAfterMatch());
        Assert.assertEquals((Object)"R22Reb0", (Object)match.getLocation());
        Assert.assertEquals((Object)"reb", (Object)match.getPatternName());
    }

    @Test
    public void testFlexible() {
        Mapping.Match match = this.mapping.match("periodicTasks/monitor-check/R22/Reb0/xyz");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"periodicTasks/monitor-check/xyz", (Object)match.getPathAfterMatch());
        Assert.assertEquals((Object)"R22Reb0", (Object)match.getLocation());
        Assert.assertEquals((Object)"reb", (Object)match.getPatternName());
    }

    @Test
    public void testCCD() {
        Mapping.Match match = this.mapping.match("R22/Reb1/S11/abcd");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"R22S11", (Object)match.getLocation());
        Assert.assertEquals((Object)"ccd", (Object)match.getPatternName());
        Assert.assertEquals((Object)"abcd", (Object)match.getPathAfterMatch());
    }

    @Test
    public void testRTD() {
        Mapping.Match match = this.mapping.match("Cold_Temp/CLP-RTD-00/limitHi");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"RTD-00", (Object)match.getLocation());
        Assert.assertEquals((Object)"rtd", (Object)match.getPatternName());
        Assert.assertEquals((Object)"Cold_Temp/limitHi", (Object)match.getPathAfterMatch());
    }

    @Test
    public void testTrimHeaters() {
        Mapping.Match match = this.mapping.match("Trim_Htrs/ColdHtr1_I/blah");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"Htr1", (Object)match.getLocation());
        Assert.assertEquals((Object)"trim", (Object)match.getPatternName());
        Assert.assertEquals((Object)"Trim_Htrs/I/blah", (Object)match.getPathAfterMatch());
    }
}

