/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.OrderedProperties;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.XMLMaker2Test;
import org.lsst.ccs.camera.sal.xml.util.ChecksumExtractorUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MakeAllXMLTest {
    @Test
    public void testAllAuxTelTelemetryXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.testAllXML(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
    }

    @Test
    public void testAllAuxTelConfigurationXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.testAllXML(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
    }

    @Test
    public void testAllComCamTelemetryXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.testAllXML(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
    }

    @Test
    public void testAllComCamConfigurationXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.testAllXML(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
    }

    @Test
    public void testAllCameraTelemetryXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.testAllXML(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY);
    }

    @Test
    public void testAllCameraConfigurationXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.testAllXML(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED);
    }

    private void testAllXML(Camera camera, XMLMaker2.SALType saltype) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(camera, saltype, false);
    }

    private static void testAllXML(Camera camera, XMLMaker2.SALType saltype, boolean updateChecksum) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, XPathExpressionException {
        String message = String.format("Camera: %s SALType: %s", camera, saltype);
        Map<String, Long> computed = MakeAllXMLTest.computeChecksumsForAllXML(camera, saltype);
        String fileName = "MakeAllXMLTest_" + camera + "_" + saltype + ".properties";
        if (updateChecksum) {
            String fullPath = MakeAllXMLTest.class.getResource(fileName).getPath().replace("target/test-classes/", "src/test/resources/");
            System.out.println("Updating checksum file " + fullPath);
            OrderedProperties.store(computed, new PrintStream(new File(fullPath)), message);
        } else {
            OrderedProperties.store(computed, System.out, message);
            LinkedHashMap<String, Long> read = new LinkedHashMap<String, Long>();
            try (InputStream in = MakeAllXMLTest.class.getResourceAsStream(fileName);){
                Assert.assertNotNull((String)message, (Object)in);
                OrderedProperties.load(read, in);
            }
            for (String key : computed.keySet()) {
                Assert.assertEquals((String)(message + " Component: " + key), (Object)computed.get(key), read.get(key));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("no.missing.sal.class.warning", "true");
        for (XMLMaker2.SALType t : XMLMaker2.SALType.values()) {
            for (Camera c : Camera.values()) {
                MakeAllXMLTest.testAllXML(c, t, true);
            }
        }
    }

    private static Map<String, Long> computeChecksumsForAllXML(Camera camera, XMLMaker2.SALType saltype) throws ParserConfigurationException, TransformerException, IOException, ClassNotFoundException, XPathExpressionException {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        XMLMaker2 maker = new XMLMaker2(false);
        ChecksumExtractorUtils utils = new ChecksumExtractorUtils();
        MakeXMLConfiguration config = MakeXMLConfiguration.getInstance((Camera)camera, (XMLMaker2.SALType)saltype);
        List dictConfigs = config.getOrderedListOfDictionaryConfigurations();
        for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : dictConfigs) {
            SALClassDescriptionMaker descriptionMaker = new SALClassDescriptionMaker(dictConfig, config.getMapping());
            if (descriptionMaker.getSALClassDescriptions().isEmpty()) continue;
            Document document = maker.createDocument(config.getSALType());
            maker.generateXML(document, descriptionMaker);
            long checkSum = MakeAllXMLTest.checkXML(maker, document);
            result.put(dictConfig.getComponentName(), checkSum);
            result.putAll(utils.extractChecksums(document));
        }
        return result;
    }

    private static long checkXML(XMLMaker2 maker, Document dom) throws TransformerException {
        CRC32 checkSum = new CRC32();
        StreamResult output = new StreamResult(new CheckedOutputStream(new XMLMaker2Test.NullOutputStream(), checkSum));
        maker.writeXML(output, dom);
        return checkSum.getValue();
    }
}

