package org.lsst.ccs.bus.messages;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import org.lsst.ccs.command.Dictionary;


/**
 * StatusMessage dedicated to command dictionary publication.
 * It contains a map of all the targets/dictionaries for a given agent.
 * 
 * This object is published by the {@code AgentCommandDictionaryService}; consoles
 * should listen to the STATUS bus for these publications.
 * 
 * @author LSST CCS Team
 * 
 */
public final class StatusCommandDictionary extends StatusMessage<HashMap<String, Dictionary>,Object>  {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -69280792879L;
    
   
    public StatusCommandDictionary(byte[] ser, String compressionProtocol) {
        super(Map.class, ser, compressionProtocol);
    }


    /**
     * Get the actual dictionary contained in this StatusMessage.
     * @return The Map of targets/dictionaries.
     */
    public HashMap<String, Dictionary> getDictionary() {                
        HashMap<String, Dictionary> tmpDict = getObject();
        String agentName = getOriginAgentInfo().getName();
        return setTargetsForAgent(tmpDict, agentName);
    }
    
    
    @Override
    protected Object encodeObject(HashMap<String, Dictionary> dictionary) {
        return null;
    }

    public static HashMap<String, Dictionary> setTargetsForAgent(Map<String, Dictionary> rawDict, String agentName) {
        HashMap<String, Dictionary> dictWithCorrectTargets = new LinkedHashMap<>(rawDict.size());
        for ( Entry<String, Dictionary> e : rawDict.entrySet() ) {
            String oldTarget = e.getKey();
            if ( !oldTarget.startsWith(agentName) ) {
                oldTarget = agentName + oldTarget;
            }
            dictWithCorrectTargets.put(oldTarget, e.getValue());
        }  
        return dictWithCorrectTargets;
    } 
    
    

}
