package org.lsst.ccs.bus.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for Device (monitor package)
 *
 *  @author The LSST CCS Team
 */
public enum DeviceAlerts {

    DEVICE_OFFLINE ("DeviceOffline", "Device is offline");

    private final String id, description;
    
    DeviceAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert(String name) {
        return new Alert(getAlertId(name), getDescription());
    }

    public String getAlertId(String name) {
        return getId()+"/"+name;
    }
}
