package org.lsst.ccs.bus.messages;


import org.lsst.ccs.bus.states.StateBundle;

/**
 * A StatusMessage containing a full StateBundle.
 * This message is published every time the current agent sees a new agent 
 * joining the cluster.
 * 
 * @author The LSST CCS Team
 */
public final class StatusStateBundle extends StatusMessage<StateBundle,Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 59534824561L;
    
    /**
     * Create a StatusStateBundle object.
     * 
     * @param fullState The old state before the State change
     */
    public StatusStateBundle(StateBundle fullState) {
        super(fullState);
    }


    /**
     * Get the full state of the Agent.
     * @return The full state of the Agent.
     */
    public StateBundle getFullState() {
        return getObject();
    }

    @Override
    protected Object encodeObject(StateBundle obj) {
        return null;
    }

    @Override
    public String toString() {
        return "Full state: "+getFullState();
    }
    
    
    
}
