/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.messages.Complex1;
import org.lsst.ccs.bus.messages.Complex2;
import org.lsst.ccs.bus.messages.Complex3;
import org.lsst.ccs.bus.messages.DAQDriverStats;
import org.lsst.ccs.bus.messages.DAQFirmwareStats;
import org.lsst.ccs.bus.messages.DAQRdsStats;
import org.lsst.ccs.bus.messages.DAQRmsStats;
import org.lsst.ccs.bus.messages.Enum1;
import org.lsst.ccs.bus.messages.SimpleChild;
import org.lsst.ccs.bus.messages.SimpleWithProps;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.messages.WithNullValue;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

public class TestStatusEncoding
implements Serializable {
    @BeforeClass
    public static void prepareTest() {
        System.setProperty("org.lsst.ccs.project", "org-lsst-ccs-some-proj");
        System.setProperty("org.lsst.ccs.project.version", "1.8-SNAPSHOT");
        System.setProperty("org.lsst.ccs.jenkins.build.number", "23563");
        System.setProperty("org.lsst.ccs.jenkins.build.id", "adjks-3333 akskll   2");
        System.setProperty("org.lsst.ccs.jenkins.build.url", "http://srs.slac.stanford.edu/hudson?build=222");
        System.setProperty("org.lsst.ccs.jenkins.build.jdk", "1.8.0.34-p");
        System.setProperty("org.lsst.ccs.source.code.url", "svn+ssh://dev.lsstcorp.org/camera/CameraControl/some");
        System.setProperty("org.lsst.ccs.source.code.revision", "3432");
    }

    @AfterClass
    public static void clearTest() {
        System.setProperty("org.lsst.ccs.project.version", "");
        System.setProperty("org.lsst.ccs.jenkins.build.number", "");
        System.setProperty("org.lsst.ccs.jenkins.build.id", "");
        System.setProperty("org.lsst.ccs.jenkins.build.url", "");
        System.setProperty("org.lsst.ccs.jenkins.build.jdk", "");
        System.setProperty("org.lsst.ccs.source.code.url", "");
        System.setProperty("org.lsst.ccs.source.code.revision", "");
    }

    @Test
    public void testDaqStatsEncoding() throws Exception {
        ArrayList<String> allOfThem = new ArrayList<String>();
        byte b = 1;
        DAQFirmwareStats firmwareStats = new DAQFirmwareStats(b, b, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        KeyValueData firmware = new KeyValueData("firmware", (Serializable)firmwareStats);
        Assert.assertTrue((boolean)firmware.needsEncoding());
        StatusSubsystemData firmwareData = new StatusSubsystemData(firmware);
        KeyValueDataList obj1 = firmwareData.getEncodedData();
        for (KeyValueData d : obj1.getListOfKeyValueData()) {
            Assert.assertTrue((!allOfThem.contains(d.getKey()) ? 1 : 0) != 0);
            allOfThem.add(d.getKey());
            Assert.assertTrue((boolean)allOfThem.contains(d.getKey()));
        }
        DAQRmsStats rmsStats = new DAQRmsStats(b, b, b, b, b, b, b, b, b, b, b, b, b, b);
        KeyValueData rms = new KeyValueData("rms", (Serializable)rmsStats);
        StatusSubsystemData rmsData = new StatusSubsystemData(rms);
        KeyValueDataList obj2 = rmsData.getEncodedData();
        for (KeyValueData d : obj2.getListOfKeyValueData()) {
            Assert.assertTrue((!allOfThem.contains(d.getKey()) ? 1 : 0) != 0);
            allOfThem.add(d.getKey());
            Assert.assertTrue((boolean)allOfThem.contains(d.getKey()));
        }
        DAQDriverStats driverStats = new DAQDriverStats(b, b, b, b, b, b, b, b);
        KeyValueData driver = new KeyValueData("driver", (Serializable)driverStats);
        StatusSubsystemData driverData = new StatusSubsystemData(driver);
        KeyValueDataList obj3 = driverData.getEncodedData();
        for (KeyValueData d : obj3.getListOfKeyValueData()) {
            Assert.assertTrue((!allOfThem.contains(d.getKey()) ? 1 : 0) != 0);
            allOfThem.add(d.getKey());
            Assert.assertTrue((boolean)allOfThem.contains(d.getKey()));
        }
        DAQRdsStats rdsStats = new DAQRdsStats(b, b, b, b, b, b, b, b, b, b, b, b);
        KeyValueData rds = new KeyValueData("rds", (Serializable)rdsStats);
        StatusSubsystemData rdsData = new StatusSubsystemData(rds);
        KeyValueDataList obj4 = rdsData.getEncodedData();
        for (KeyValueData d : obj4.getListOfKeyValueData()) {
            Assert.assertTrue((!allOfThem.contains(d.getKey()) ? 1 : 0) != 0);
            allOfThem.add(d.getKey());
            Assert.assertTrue((boolean)allOfThem.contains(d.getKey()));
        }
        KeyValueDataList dataList = new KeyValueDataList("daqStats");
        dataList.addData("firmware", (Serializable)new DAQFirmwareStats(b, b, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L));
        dataList.addData("rms", (Serializable)new DAQRmsStats(b, b, b, b, b, b, b, b, b, b, b, b, b, b));
        dataList.addData("driver", (Serializable)new DAQDriverStats(b, b, b, b, b, b, b, b));
        dataList.addData("rds", (Serializable)new DAQRdsStats(b, b, b, b, b, b, b, b, b, b, b, b));
        StatusSubsystemData allData = new StatusSubsystemData((KeyValueData)dataList);
        KeyValueDataList obj5 = allData.getEncodedData();
        for (KeyValueData d : obj5.getListOfKeyValueData()) {
            String dataKey = d.getKey().replace("daqStats/", "");
            Assert.assertTrue((boolean)allOfThem.contains(dataKey));
            Assert.assertTrue((boolean)allOfThem.remove(dataKey));
            Assert.assertTrue((!allOfThem.contains(dataKey) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)allOfThem.isEmpty());
    }

    @Test
    public void testSimpleChildEncoding() throws Exception {
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        KeyValueData k = new KeyValueData("", (Serializable)child);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj1 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("name", (Serializable)((Object)"aSin")));
        toFind.add(new KeyValueData("value", (Serializable)Integer.valueOf(666)));
        toFind.add(new KeyValueData("valDouble", (Serializable)Double.valueOf(0.7)));
        this.testEncodedListsNew(obj1, toFind);
        SimpleChild res = (SimpleChild)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res, (Object)child);
    }

    @Test
    public void testComplex1ObjectEncoding() throws Exception {
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        Complex1 complex1 = new Complex1(child, 966);
        KeyValueData k = new KeyValueData("", (Serializable)complex1);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj2 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("son/name", (Serializable)((Object)"aSin")));
        toFind.add(new KeyValueData("son/value", (Serializable)Integer.valueOf(666)));
        toFind.add(new KeyValueData("son/valDouble", (Serializable)Double.valueOf(0.7)));
        toFind.add(new KeyValueData("id", (Serializable)Integer.valueOf(966)));
        this.testEncodedListsNew(obj2, toFind);
        Complex1 res2 = (Complex1)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res2, (Object)complex1);
    }

    @Test
    public void testComplex2ObjectEncoding() throws Exception {
        Complex2 complex2 = new Complex2(new BigDecimal("33.33"), 945);
        KeyValueData k = new KeyValueData("", (Serializable)complex2);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj3 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("value", (Serializable)new BigDecimal("33.33")));
        toFind.add(new KeyValueData("id", (Serializable)Integer.valueOf(945)));
        this.testEncodedListsNew(obj3, toFind);
        Complex2 res3 = (Complex2)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res3, (Object)complex2);
    }

    @Test
    public void testEnumerationEncoding() throws Exception {
        KeyValueData k = new KeyValueData("", (Serializable)((Object)Enum1.MENEL));
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj4 = e.getEncodedData();
        ArrayList<KeyValueData> list4 = new ArrayList<KeyValueData>();
        for (KeyValueData d : obj4) {
            list4.add(d);
        }
        Assert.assertTrue((list4.size() == 1 ? 1 : 0) != 0);
        KeyValueData d = (KeyValueData)list4.get(0);
        Assert.assertTrue((boolean)d.getKey().equals(""));
        String en = (String)((Object)d.getValue());
        Assert.assertTrue((boolean)en.equals("MENEL"));
        Enum1 res4 = (Enum1)((Object)((KeyValueData)e.getObject()).getValue());
        Assert.assertEquals((Object)((Object)res4), (Object)((Object)Enum1.MENEL));
    }

    @Test
    public void testComplex3ObjectEncoding() throws Exception {
        Complex3 c3 = new Complex3(55, Enum1.MENEL);
        KeyValueData k = new KeyValueData("", (Serializable)c3);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj5 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("val", (Serializable)Integer.valueOf(55)));
        toFind.add(new KeyValueData("anEnum", (Serializable)((Object)"MENEL")));
        toFind.add(new KeyValueData("bitset", (Serializable)Long.valueOf(55L)));
        this.testEncodedListsNew(obj5, toFind);
        Complex3 res5 = (Complex3)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res5, (Object)c3);
    }

    @Test
    public void testNullValueEncoding() throws Exception {
        WithNullValue withNullValue = new WithNullValue();
        KeyValueData k = new KeyValueData("", (Serializable)withNullValue);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj6 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("name", null));
        toFind.add(new KeyValueData("value", (Serializable)Integer.valueOf(0)));
        this.testEncodedListsNew(obj6, toFind);
        WithNullValue res6 = (WithNullValue)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res6, (Object)withNullValue);
    }

    @Test
    public void testConstructorWithPropertiesEncoding() throws Exception {
        SimpleWithProps simpleProps = new SimpleWithProps(3, "abc");
        KeyValueData k = new KeyValueData("", (Serializable)simpleProps);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj7 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("valInt", (Serializable)Integer.valueOf(3)));
        toFind.add(new KeyValueData("valString", (Serializable)((Object)"abc")));
        this.testEncodedListsNew(obj7, toFind);
        SimpleWithProps res7 = (SimpleWithProps)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res7, (Object)simpleProps);
    }

    @Test
    public void testMapEncoding() throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("one", 1);
        map.put("another", new SimpleChild("child", 45, 2345.0));
        map.put("last", "done");
        KeyValueData k = new KeyValueData("", (Serializable)map);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("one", (Serializable)Integer.valueOf(1)));
        toFind.add(new KeyValueData("another/name", (Serializable)((Object)"child")));
        toFind.add(new KeyValueData("another/value", (Serializable)Integer.valueOf(45)));
        toFind.add(new KeyValueData("another/valDouble", (Serializable)Double.valueOf(2345.0)));
        toFind.add(new KeyValueData("last", (Serializable)((Object)"done")));
        this.testEncodedListsNew(obj, toFind);
        Map res = (Map)((Object)((KeyValueData)e.getObject()).getValue());
        Assert.assertEquals((Object)res, map);
    }

    @Test
    public void testRuntimeInfoEncoding() throws Exception {
        RuntimeInfo runInfo = new RuntimeInfo();
        KeyValueData k = new KeyValueData("", (Serializable)runInfo);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("nThreads", (Serializable)Integer.valueOf(runInfo.getNThreads())));
        toFind.add(new KeyValueData("maxMemory", (Serializable)Long.valueOf(runInfo.getMaxMemory())));
        toFind.add(new KeyValueData("totalMemory", (Serializable)Long.valueOf(runInfo.getTotalMemory())));
        toFind.add(new KeyValueData("freeMemory", (Serializable)Long.valueOf(runInfo.getFreeMemory())));
        toFind.add(new KeyValueData("processCpuLoad", (Serializable)Double.valueOf(runInfo.getProcessCpuLoad())));
        toFind.add(new KeyValueData("systemCpuLoad", (Serializable)Double.valueOf(runInfo.getSystemCpuLoad())));
        toFind.add(new KeyValueData("uptime", (Serializable)Long.valueOf(runInfo.getUptime())));
        toFind.add(new KeyValueData("availableMemory", (Serializable)Long.valueOf(runInfo.getAvailableMemory())));
        toFind.add(new KeyValueData("usedMemory", (Serializable)Long.valueOf(runInfo.getUsedMemory())));
        this.testEncodedListsNew(obj, toFind);
        RuntimeInfo res = (RuntimeInfo)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((long)runInfo.getFreeMemory(), (long)res.getFreeMemory());
        Assert.assertEquals((long)runInfo.getMaxMemory(), (long)res.getMaxMemory());
        Assert.assertEquals((long)runInfo.getNThreads(), (long)res.getNThreads());
        Assert.assertEquals((double)runInfo.getProcessCpuLoad(), (double)res.getProcessCpuLoad(), (double)0.0);
        Assert.assertEquals((double)runInfo.getSystemCpuLoad(), (double)res.getSystemCpuLoad(), (double)0.0);
        Assert.assertEquals((long)runInfo.getTotalMemory(), (long)res.getTotalMemory());
        Assert.assertEquals((long)runInfo.getAvailableMemory(), (long)res.getAvailableMemory());
        Assert.assertEquals((long)runInfo.getUsedMemory(), (long)res.getUsedMemory());
        Assert.assertEquals((long)runInfo.getUptime(), (long)res.getUptime());
    }

    @Test
    public void testStateBundleEncoding() throws Exception {
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setState(new Enum[]{PhaseState.CLOSING});
        sb.setState(new Enum[]{PhaseState.INITIALIZING});
        sb.setState(new Enum[]{OperationalState.ENGINEERING_FAULT});
        sb.setState(new Enum[]{AlertState.NOMINAL});
        KeyValueData k = new KeyValueData("", (Serializable)sb);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("allStates/PhaseState", (Serializable)((Object)"INITIALIZING")));
        toFind.add(new KeyValueData("allStates/OperationalState", (Serializable)((Object)"ENGINEERING_FAULT")));
        toFind.add(new KeyValueData("allStates/AlertState", (Serializable)((Object)"NOMINAL")));
        toFind.add(new KeyValueData("lastModifiedCCSTimeStamp", null));
        this.testEncodedListsNew(obj, toFind);
        StateBundle res = (StateBundle)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res, (Object)sb);
    }

    @Test
    public void testAgentInfoEncoding() throws Exception {
        AgentInfo ai = new AgentInfo("a1", AgentInfo.AgentType.LISTENER);
        KeyValueData k = new KeyValueData("", (Serializable)ai);
        Assert.assertTrue((boolean)k.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData(k);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("name", (Serializable)((Object)"a1")));
        toFind.add(new KeyValueData("type", (Serializable)((Object)"LISTENER")));
        toFind.add(new KeyValueData("agentProps/agentName", (Serializable)((Object)"a1")));
        toFind.add(new KeyValueData("agentProps/agentType", (Serializable)((Object)"LISTENER")));
        toFind.add(new KeyValueData("agentStartTime/taiInstant/seconds", (Serializable)Long.valueOf(ai.getAgentStartTime().getTAIInstant().getEpochSecond())));
        toFind.add(new KeyValueData("agentStartTime/taiInstant/nanos", (Serializable)Integer.valueOf(ai.getAgentStartTime().getTAIInstant().getNano())));
        toFind.add(new KeyValueData("agentStartTime/utcInstant/seconds", (Serializable)Long.valueOf(ai.getAgentStartTime().getUTCInstant().getEpochSecond())));
        toFind.add(new KeyValueData("agentStartTime/utcInstant/nanos", (Serializable)Integer.valueOf(ai.getAgentStartTime().getUTCInstant().getNano())));
        toFind.add(new KeyValueData("agentOperationalTime", null));
        toFind.add(new KeyValueData("agentJoinedTheBusesTime", null));
        this.testEncodedListsNew(obj, toFind);
        AgentInfo res = (AgentInfo)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res, (Object)ai);
    }

    @Test
    public void testHeartBeatEncoding() throws Exception {
        StatusHeartBeat hb = new StatusHeartBeat(2);
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setState(new Enum[]{PhaseState.INITIALIZING});
        sb.setState(new Enum[]{OperationalState.ENGINEERING_FAULT});
        sb.setState(new Enum[]{AlertState.NOMINAL});
        Assert.assertTrue((hb.getEncodedData() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDataList() throws Exception {
        KeyValueDataList dl1 = new KeyValueDataList();
        Complex2 complex2 = new Complex2(new BigDecimal("33.33"), 945);
        dl1.addData("cmplx2", (Serializable)complex2);
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        Complex1 complex1 = new Complex1(child, 966);
        dl1.addData("cmplx1", (Serializable)complex1);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("one", 1);
        map.put("another", new SimpleChild("child", 45, 2345.0));
        map.put("last", "done");
        dl1.addData("map", (Serializable)map);
        Assert.assertTrue((boolean)dl1.needsEncoding());
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("cmplx2/value", (Serializable)new BigDecimal("33.33")));
        toFind.add(new KeyValueData("cmplx2/id", (Serializable)Integer.valueOf(945)));
        toFind.add(new KeyValueData("cmplx1/son/name", (Serializable)((Object)"aSin")));
        toFind.add(new KeyValueData("cmplx1/son/value", (Serializable)Integer.valueOf(666)));
        toFind.add(new KeyValueData("cmplx1/son/valDouble", (Serializable)Double.valueOf(0.7)));
        toFind.add(new KeyValueData("cmplx1/id", (Serializable)Integer.valueOf(966)));
        toFind.add(new KeyValueData("map/one", (Serializable)Integer.valueOf(1)));
        toFind.add(new KeyValueData("map/another/name", (Serializable)((Object)"child")));
        toFind.add(new KeyValueData("map/another/value", (Serializable)Integer.valueOf(45)));
        toFind.add(new KeyValueData("map/another/valDouble", (Serializable)Double.valueOf(2345.0)));
        toFind.add(new KeyValueData("map/last", (Serializable)((Object)"done")));
        StatusSubsystemData e = new StatusSubsystemData((KeyValueData)dl1);
        KeyValueDataList obj = e.getEncodedData();
        this.testEncodedListsNew(obj, toFind);
        KeyValueDataList res = (KeyValueDataList)e.getObject();
        int countEquals = 0;
        for (KeyValueData d : dl1) {
            for (KeyValueData d1 : res) {
                if (!d1.getKey().equals(d.getKey())) continue;
                Assert.assertEquals((Object)d1.getValue(), (Object)d.getValue());
                ++countEquals;
            }
        }
        Assert.assertTrue((countEquals == res.getListOfKeyValueData().size() ? 1 : 0) != 0);
    }

    @Test
    public void testDataTypeEncoding() throws Exception {
        KeyValueDataList dl1 = new KeyValueDataList();
        dl1.addData("test_data", (Serializable)((Object)"test_data"));
        dl1.addData("test_data1", (Serializable)((Object)"test_data1"));
        dl1.addData("test_plot", (Serializable)((Object)"test_plot"), KeyValueData.KeyValueDataType.KeyValueMetaData);
        dl1.addData("test_plot1", (Serializable)((Object)"test_plot1"), KeyValueData.KeyValueDataType.KeyValueMetaData);
        Assert.assertFalse((boolean)dl1.needsEncoding());
        StatusSubsystemData e = new StatusSubsystemData((KeyValueData)dl1);
        KeyValueDataList obj = e.getEncodedData();
        for (KeyValueData d : obj) {
            if (d.getKey().startsWith("test_data")) {
                Assert.assertTrue((d.getType() == KeyValueData.KeyValueDataType.KeyValueTrendingData ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((d.getType() == KeyValueData.KeyValueDataType.KeyValueMetaData ? 1 : 0) != 0);
        }
    }

    private void testEncodedListsNew(KeyValueDataList list, List<KeyValueData> toFind) {
        ArrayList<KeyValueData> l = new ArrayList<KeyValueData>();
        for (KeyValueData d : list) {
            l.add(d);
        }
        this.testEncodedListsNew(l, toFind);
    }

    private void testEncodedListsNew(List<KeyValueData> list, List<KeyValueData> toFind) {
        Assert.assertEquals((long)toFind.size(), (long)list.size());
        for (KeyValueData data : list) {
            KeyValueData found = null;
            String key = data.getKey();
            for (KeyValueData orig : toFind) {
                if (!orig.getKey().equals(key)) continue;
                Assert.assertEquals((Object)orig.getValue(), (Object)data.getValue());
                found = orig;
                break;
            }
            toFind.remove(found);
        }
        if (!toFind.isEmpty()) {
            for (KeyValueData d : toFind) {
                System.out.println("Item not found " + d);
            }
        }
        Assert.assertTrue((boolean)toFind.isEmpty());
    }

    @Test
    public void testSkipAllClassEncoding() throws Exception {
        SkipAllClass c = new SkipAllClass();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)c));
        KeyValueDataList encodedResult = e.getEncodedData();
        Assert.assertEquals((long)encodedResult.getListOfKeyValueData().size(), (long)0L);
    }

    @Test
    public void testSkipFieldEncoding() throws Exception {
        SkipSomeFields c = new SkipSomeFields();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)c));
        KeyValueDataList encodedResult = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("data1", (Serializable)Integer.valueOf(1)));
        toFind.add(new KeyValueData("data3", (Serializable)Integer.valueOf(3)));
        this.testEncodedListsNew(encodedResult, toFind);
    }

    @SkipEncoding
    private class SkipAllClass
    implements Serializable {
        private final int data = 1;

        private SkipAllClass() {
        }
    }

    private class SkipSomeFields
    implements Serializable {
        private final int data1 = 1;
        @SkipEncoding
        private final double data2 = 3.4;
        private final int data3 = 3;
        @SkipEncoding
        private final SkipAllClass c = new SkipAllClass();

        private SkipSomeFields() {
        }
    }
}

