package org.lsst.ccs.bus.states;

/**
 * Agent State with respect to command execution.
 * 
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams.
 * 
 * @author The LSST CCS Team
 */
public enum CommandState implements AgentState {

    /**
     * The Agent is ready to receive and execute all types of commands.
     */
    READY,
    
    /**
     * The Agent is already executing ACTION or CONFIGURATION command, only QUERY and SIGNAL commands are accepted.
     */
    ACTIVE;

}
