package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * Class to send a Lock status update
 * 
 * @author The LSST CCS Team
 */
public class StatusLock extends StatusMessage<AgentLockInfo, AgentLockInfo> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 2474407317708488843L;

    int level = -1; // means default

    public StatusLock(AgentLockInfo lock) {
        super(lock);
    }

    // to change the level of the lock
    public StatusLock(AgentLockInfo lock, int level) {
        super(lock);
        this.level = level;
    }

    @Override
    protected AgentLockInfo encodeObject(AgentLockInfo obj) {
        return null;
    }

    public int getLevel() {
        return level;
    }

}
