/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.ConfigurationData;
import org.lsst.ccs.bus.data.KeyValueDataList;

/**
 * A StatusMessage for the publication of ConfigurationData.
 * 
 * @author The LSST CCS Team
 */
public class StatusConfigurationData extends StatusMessage<ConfigurationData,Object> {


    private static final long serialVersionUID = 343533923016870L;
    private final boolean isFullData;
    private final long dataChecksum;

    public StatusConfigurationData(byte[] zippedConfigurationData, boolean isFullData) {
        this(zippedConfigurationData, 0L, isFullData);
    }
    public StatusConfigurationData(byte[] zippedConfigurationData, long dataChecksum, boolean isFullData) {
        super(ConfigurationData.class, zippedConfigurationData, "gzip");
        this.isFullData = isFullData;
        this.dataChecksum = dataChecksum;
    }

    public StatusConfigurationData(ConfigurationData configurationData, boolean isFullData) {
        super(configurationData);
        this.isFullData = isFullData;
        this.dataChecksum = configurationData.getDataChecksum();
    }
    
    public long getDataChecksum() {
        return dataChecksum;
    }
    
    public ConfigurationData getConfigurationData() {
        return getObject();
    }

    
    @Override
    protected KeyValueDataList encodeObject(ConfigurationData obj) {
        return null;
    }
    
    public boolean isFullDataPublication() {
        return isFullData;
    }
    
}
