package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * A class containing a CCSTimeStamp/double pair representing the timestamp
 * and the value of a hardware measurement.
 * 
 * @author The LSST CCS Team
 */
public class Measurement implements Serializable {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 489243324353342L;

    private final CCSTimeStamp ccsTimestamp;
    private final double value;
    
    /**
     * Build a Measurement object providing the value/timestamp pairs
     * 
     * @param value        The value of the measurement
     * @param ccsTimestamp The timestamp when the measurement was performed
     */
    public Measurement(double value, CCSTimeStamp ccsTimestamp) {
        this.value = value;
        this.ccsTimestamp = ccsTimestamp;
    }

    /**
     * Build a Measurement object from another Measurement
     * 
     * @param measurement Another Measurement object
     */
    public Measurement(Measurement measurement) {
        if (measurement == null) {
            this.value = Double.NaN;
            this.ccsTimestamp = null;
        } else {
            this.value = measurement.value;
            this.ccsTimestamp = measurement.ccsTimestamp;
        }
    }
    
    public CCSTimeStamp getCCSTimestamp() {
        return ccsTimestamp;
    }

    public double getValue() {
        return value;
    }

    @Override
    public String toString() {
        return "Value "+value+" ("+ccsTimestamp+")";
    }

}
