package org.lsst.ccs.bus.data;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 * An enumeration to distinguish between a NORMAL and SIMULATED subsystem.
 * 
 * @author The LSST CCS Team
 */

public enum RunMode {
    NORMAL, SIMULATION;

    public static final String AGENT_RUNMODE_PROPERTY="runMode";
    public static final String RUNMODE_SYSTEM_PROPERTY="org.lsst.ccs.run.mode";

    private static volatile Boolean isSimulation = null;
    
    public static RunMode getRunMode() {
        if ( isSimulation() ) {
            return SIMULATION;
        }
        return NORMAL;
    }
    
    /**
     * This method opens Bootstrap resources/files to assess if property
     * org.lsst.ccs.run.mode has been set to true/false. 
     * 
     * @return true/false to indicate if we are in simulation mode.
     */
    public static boolean isSimulation() {
        if ( isSimulation == null ) {
            isSimulation = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty(RUNMODE_SYSTEM_PROPERTY, "normal").equals(SIMULATION.name().toLowerCase());
        }
        return isSimulation;
    }
}
