package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * A dictionary of published data.
 * @author LSST CCS Team
 */
public interface DataProviderDictionary extends Serializable {
    
    /**
     * @return the existing list of DataProviders
     */
    public List<DataProviderInfo> getDataProviderInfos();

    /**
     * @return the existing groups
     */
    @Deprecated
    public Set<String> getGroups();

    /**
     * @param group
     * @return 
     */
    @Deprecated
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group);
    
    /**
     * Get the CCSTimeStamp of when this dictionary was created.
     * 
     * @return The CCSTimeStamp when this dictionary was created.
     */
    @Deprecated
    public CCSTimeStamp getCCSTimeStamp();
    
    /**
     * Get the DataProviderInfo definition for the provided path.
     * @param path The path for the desired DataProviderInfo
     * @return The corresponding DataProviderInfo, or null otherwise.
     */
    public DataProviderInfo getDataProviderInfoForPath(String path);
    
    /**
     * Returns the size of this dictionary.
     * @return Number of entries in this dictionary.
     */
    public int size();
   
}