package org.lsst.ccs.bus.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Field annotation to define data attributes.
 * If applied at the Class level it provides defaults for all the inner (non-transient) fields.
 * 
 * @author The lSST CCS Team
 */
@Target({ElementType.FIELD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DataAttributes {
    
    /**
     * The Units for this Data field
     * @return The units.
     */
    String units() default "";

    /**
     * The Description for this Data field
     * @return The units.
     */
    String description() default "";

}
