package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.AgentInfo;

/**
 * A status message containing an AgentInfo object.
 * It contains information about the Agent, including Agent properties.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class StatusAgentInfo extends StatusMessage<AgentInfo,Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 45345679843L;

    /**
     * Create a StatusAgentInfo message by providing Agent's AgentInfo.
     * @param agentInfo The AgentInfo for this Agent.
     * 
     */
    public StatusAgentInfo(AgentInfo agentInfo){
        super(agentInfo);
    }
        
    /**
     * Get the RuntimeInfo object contained in this message.
     * @return The RuntimeInfo object embedded in the message.
     */
    public AgentInfo getAgentInfo() {
        return getObject();
    }

    @Override
    protected Object encodeObject(AgentInfo obj) {
        return null;
    }
    
    
}
