package org.lsst.ccs.bus.states;

/**
 * The Operational State of an Agent.
 * It relates to which commands it can accept and if there is any problem with the hardware.
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * 
 * @author LSST CCS Team
 */

public enum OperationalState implements AgentState {
    /**
     * Only level 0 (NORMAL) commands are accepted.
     * 
     */
    NORMAL,

    /**
     * Commands can be accepted for any Component (provided a sufficient level).
     * When an Agent starts up it goes in ENGINEERING_OK if all was well
     * during initialization.
     * 
     */
    ENGINEERING_OK,

    /**
     * Commands can be accepted for any Component (provided a sufficient level).
     * When an Agent starts up it goes in ENGINEERING_FAULT if there was any
     * problem during initialization.
     * After initialization is complete an Agent will reach the ENGINEERING_FAILURE
     * state if any problem occurs with the Agent (for example a hardware problem) 
     * Is this FAULT or FAILURE?
     */
    ENGINEERING_FAULT;
}
