package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueDataList;

/**
 * A status message containing a ConfigurationInfo object.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class StatusConfigurationInfo extends StatusMessage<ConfigurationInfo,Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -31335289870L;

    /**
     * Create a StatusConfigurationInfo message by providing the state of the agent
     * and the ConfigurationInfo object to be sent.
     * @param configurationInfo The ConfigurationInfo object to be sent.
     * 
     */
    public StatusConfigurationInfo(ConfigurationInfo configurationInfo){
        super(configurationInfo, true);
    }
        
    /**
     * Get the ConfigurationInfo object contained in this message.
     * @return The ConfigurationInfo object embedded in the message.
     */
    public ConfigurationInfo getConfigurationInfo() {
        return getObject();
    }

    @Override
    protected KeyValueDataList encodeObject(ConfigurationInfo obj) {
        return null;
    }
    
}
