package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * A dictionary of published data.
 * @author LSST CCS Team
 */
public interface DataProviderDictionary extends Serializable {
    
    /**
     * @return the existing list of DataProviders
     */
    public List<DataProviderInfo> getDataProviderInfos();

    /**
     * @return the existing groups
     */
    @Deprecated
    public Set<String> getGroups();

    /**
     * @param group
     * @return 
     */
    @Deprecated
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group);
    
    /**
     * Get the CCSTimeStamp of when this dictionary was created.
     * 
     * @return The CCSTimeStamp when this dictionary was created.
     */
    @Deprecated
    public CCSTimeStamp getCCSTimeStamp();
    
    /**
     * Get the DataProviderInfo definition for the provided path.
     * @param path The path for the desired DataProviderInfo
     * @return The corresponding DataProviderInfo, or null otherwise.
     */
    public DataProviderInfo getDataProviderInfoForPath(String path);
    
    /**
     * Returns the size of this dictionary.
     * @return Number of entries in this dictionary.
     */
    public int size();
    
    /**
     * Compares two dictionaries for equality.
     * 
     * @param d1 First dictionary.
     * @param d2 Second dictionary.
     * @param ordered If {@code true}, the order of entries is taken into account.
     * @return {@code true} if the two dictionaries are equal.
     */
    static boolean equals(DataProviderDictionary d1, DataProviderDictionary d2,  boolean ordered) {
        if (d1 == d2) return true;
        if (d1 == null || d2 == null) return false;
        if (ordered) {
            return Objects.equals(d1.getDataProviderInfos(), d2.getDataProviderInfos());
        } else {
            return Objects.equals(new HashSet<>(d1.getDataProviderInfos()), new HashSet<>(d2.getDataProviderInfos()));
        }
    }
   
}