package org.lsst.ccs.bus.states;

import java.io.Serializable;

/**
 * The DataProviderState of a data provider reflects the current operating conditions of
 * the provider. It takes in consideration interaction with the underlying
 * hardware and the validity of the data against the data validator attached to the
 * data provider, if it exists.
 *
 * @author LSST CCS Team
 */
public enum DataProviderState implements Serializable {
   
    /**
     * The hardware device is unreachable.
     */
    OFF_LINE,
    /**
     * The hardware is online but it is not being read.
     */
    @Deprecated
    DISABLED,
    /**
     * The hardware is online, successfully read, and the data validator is
     * disabled.
     */
    @Deprecated
    NOT_VALIDATED,
    /**
     * The hardware is online, successfully read and validated by the
     * DataValidator.
     */
    NOMINAL,
    /**
     * The hardware is online, successfully read, the data validator validates
     * it at WARNING.
     */
    WARNING,
    /**
     * The hardware is online, successfully read, the data validator validates
     * it at ALARM.
     */
    ALARM
    
}