/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class AgentInfo
implements Serializable {
    private static final long serialVersionUID = 716901596341446997L;
    private final String name;
    private final AgentType type;
    private final Properties agentProps;
    public static final String AGENT_NAME_PROP = "agentName";
    public static final String AGENT_TYPE_PROP = "agentType";
    public static final String AGENT_OFFLINE_PROP = "agentOffline";
    public static final String AGENT_JXM_PORT_PROP = "org.lsst.ccs.agent.jmxport";
    private final CCSTimeStamp agentStartTime;
    private CCSTimeStamp agentOperationalTime;
    private CCSTimeStamp agentJoinedTheBusesTime;

    public AgentInfo(String name, AgentType type) {
        this(name, type, new Properties());
    }

    public AgentInfo(String name, AgentType type, Properties agentProps) {
        this.agentProps = agentProps;
        this.name = name;
        this.type = type;
        this.agentProps.setProperty(AGENT_NAME_PROP, name);
        this.agentProps.setProperty(AGENT_TYPE_PROP, type.name());
        this.agentStartTime = CCSTimeStamp.currentTime();
    }

    public String getName() {
        return this.name;
    }

    public AgentType getType() {
        return this.type;
    }

    public String getAgentProperty(String property) {
        return this.getAgentProperty(property, null);
    }

    public String getAgentProperty(String property, String def) {
        return this.agentProps != null ? this.agentProps.getProperty(property, def) : def;
    }

    public boolean hasAgentProperty(String property) {
        return this.getAgentProperty(property) != null;
    }

    public Properties getAgentProperties() {
        return this.agentProps;
    }

    public CCSTimeStamp getAgentStartTime() {
        return this.agentStartTime;
    }

    public final synchronized void setAgentOperationalTime() {
        if (this.agentOperationalTime != null) {
            throw new RuntimeException("The Agent Operational time can be set only once! Something went wrong!");
        }
        this.agentOperationalTime = CCSTimeStamp.currentTime();
    }

    public final synchronized CCSTimeStamp getAgentOperationalTime() {
        if (this.agentOperationalTime == null) {
            this.agentOperationalTime = CCSTimeStamp.currentTimeFromMillis((long)this.agentStartTime.getUTCInstant().plus(Duration.ofMinutes(3L)).toEpochMilli());
        }
        return this.agentOperationalTime;
    }

    public final synchronized void setAgentJoinedTheBusesTime() {
        if (this.agentJoinedTheBusesTime != null) {
            throw new RuntimeException("The Agent Operational time can be set only once! Something went wrong!");
        }
        this.agentJoinedTheBusesTime = CCSTimeStamp.currentTime();
    }

    public final synchronized CCSTimeStamp getAgentJoinedTheBusesTime() {
        if (this.agentJoinedTheBusesTime == null) {
            this.agentJoinedTheBusesTime = this.getAgentOperationalTime();
        }
        return this.agentJoinedTheBusesTime;
    }

    public boolean isAgentWorkerOrService() {
        return this.type.compareTo(AgentType.WORKER) >= 0;
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.type);
    }

    public boolean equals(Object a) {
        if (!(a instanceof AgentInfo)) {
            return false;
        }
        AgentInfo agent = (AgentInfo)a;
        return this.getName().equals(agent.getName()) && this.getType().equals((Object)agent.getType());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        hash = 89 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean isScriptingConsole() {
        if (this.getType().equals((Object)AgentType.CONSOLE)) {
            String consoleType = this.getAgentProperty("org.lsst.ccs.console.type");
            if (consoleType != null && !consoleType.isEmpty()) {
                return "scripting".equals(consoleType);
            }
            return false;
        }
        return false;
    }

    public boolean isGraphicalConsole() {
        if (this.getType().equals((Object)AgentType.CONSOLE)) {
            String consoleType = this.getAgentProperty("org.lsst.ccs.console.type");
            if (consoleType != null && !consoleType.isEmpty()) {
                return !"scripting".equals(consoleType) && !"shell".equals(consoleType);
            }
            return true;
        }
        return false;
    }

    public static enum AgentType {
        LISTENER("Listener"),
        CONSOLE("Console"),
        WORKER("Worker"),
        SERVICE("Service"),
        MCM("MCM"),
        OCS_BRIDGE("OCS bridge"),
        LOCK_MANAGER("Lock manager"),
        MMM("MMM");

        private final String displayName;

        private AgentType(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }
    }
}

