/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;

public class DataDictionaryTest {
    static List<DataProviderInfo> input0;
    static DataDictionary instance0;

    @BeforeClass
    public static void setUpClass() {
        input0 = DataDictionaryTest.dict0();
        instance0 = new DataDictionary(input0);
    }

    @AfterClass
    public static void tearDownClass() {
        input0 = null;
        instance0 = null;
        System.out.println("Done testing DataDictionary");
    }

    @Test
    public void testGetDataProviderInfos() {
        System.out.println("getDataProviderInfos");
        HashMap expResult = new HashMap();
        input0.forEach(d -> expResult.put(d.getFullPath(), d));
        HashMap result = new HashMap();
        instance0.getDataProviderInfos().forEach(d -> result.put(d.getFullPath(), d));
        Assert.assertEquals(expResult, result);
    }

    @Test
    public void testGetDataProviderInfoForPath() {
        System.out.println("getDataProviderInfoForPath");
        for (DataProviderInfo d : input0) {
            DataProviderInfo dOut = instance0.getDataProviderInfoForPath(d.getFullPath());
            Assert.assertEquals((Object)d, (Object)dOut);
        }
    }

    private static List<DataProviderInfo> dict0() {
        LinkedList<DataProviderInfo> out = new LinkedList<DataProviderInfo>();
        String path = "a0";
        String key = "";
        HashMap<DataProviderInfo.Attribute, String> att = new HashMap<DataProviderInfo.Attribute, String>();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        out.add(new DataProviderInfo(path, key, att));
        path = "a0/a1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        out.add(new DataProviderInfo(path, key, att));
        path = "a0/b1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        out.add(new DataProviderInfo(path, key, att));
        path = "a0/c1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "L");
        out.add(new DataProviderInfo(path, key, att));
        path = "b0/b1";
        key = "b1";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        out.add(new DataProviderInfo(path, key, att));
        path = "b0/b2";
        key = "b2";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        out.add(new DataProviderInfo(path, key, att));
        path = "b0/b1/b3/a4";
        key = "";
        att = null;
        out.add(new DataProviderInfo(path, key, att));
        path = "b0/b1/b3/b4";
        key = "";
        att = null;
        out.add(new DataProviderInfo(path, key, att));
        path = "b0/b2/b3/a4";
        key = "";
        att = null;
        out.add(new DataProviderInfo(path, key, att));
        path = "b0/b2/b3/b4";
        key = "";
        att = null;
        out.add(new DataProviderInfo(path, key, att));
        path = "d0/d1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "Desc main");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        out.add(new DataProviderInfo(path, key, att));
        path = "d0/d1";
        key = "limitHigh";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        out.add(new DataProviderInfo(path, key, att));
        path = "d0/d1";
        key = "limitLow";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        out.add(new DataProviderInfo(path, key, att));
        path = "d0/d2";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "Desc main");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        out.add(new DataProviderInfo(path, key, att));
        path = "d0/d2";
        key = "limitHigh";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        out.add(new DataProviderInfo(path, key, att));
        path = "d0/d2";
        key = "limitLow";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        out.add(new DataProviderInfo(path, key, att));
        return out;
    }
}

