package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.states.ConfigurationState;

/**
 * A Class containing the current configuration data.
 * 
 * @author The LSST CCS Team
 */
public class ConfigurationData implements Serializable {

    private static final long serialVersionUID = 5968743302322344L;
    
    private ConfigurationState configurationState;    
    private Map<String,String> configurationData = new HashMap<>();
    private Map<String,String> categoryDescription = new HashMap<>();
    private String configurationDescription;
    private Map<String,Long> categoryChecksum;
    private String configOperation;
    
    /**
     * Get the full configuration description.
     * @return The full configuration description.
     */
    public String getConfigurationDescription() {
        return configurationDescription;
    }
    
    /**
     * Get the full category description for the given category.
     * @param category The provided category name.
     * @return  The category description for the provided category name.
     */
    public String getCategoryDescription(String category) {
        return categoryDescription.get(category);
    }

    
    /**
     * Get the current value for a given configuration parameter.
     * 
     * @param parameterPath The configuration parameter path.
     * @return The configuration parameter value.
     */
    public String getConfigurationParameterValue(String parameterPath) {
        return configurationData.get(parameterPath);
    }

    
    /**
     * Get the current ConfigurationState
     * @return The ConfigurationState
     */
    public ConfigurationState getConfigurationState() {
        return configurationState;
    }
    
    /**
     * Get the data values checksum for the given category.
     * @param category The input category.
     * @return The checksum for the provided category.
     */
    public long getCategoryChecksum(String category) {
        return categoryChecksum.get(category);
    }   
    
    /**
     * Get the configuration operation that lead to this publication.
     * @return the configuration operation.
     */
    public String getConfigurationOperation() {
        return configOperation;
    }
}
