/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;

public class SingleCategoryTag
implements Serializable {
    private static final long serialVersionUID = 8606602350889253605L;
    private final String category;
    private final String source;
    private final String tag;
    private final String version;
    public static final String DEFAULT_VERSION = "d";
    private static Map<String, String> defaultCategorySources = new ConcurrentHashMap<String, String>();
    private static String defaultForAllCategories = "<description>";

    public SingleCategoryTag(String source, String tag, String category) {
        this(source, tag, category, DEFAULT_VERSION);
    }

    public SingleCategoryTag(String source, String tag, String category, String version) {
        this.category = category;
        this.source = source;
        this.tag = tag;
        this.version = version;
        if (category == null) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null category!!");
        }
        if (tag == null) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null tag!!");
        }
    }

    public SingleCategoryTag(SingleCategoryTag t) {
        this(t, t.version);
    }

    public SingleCategoryTag(SingleCategoryTag t, String version) {
        this(t.source, t.tag, t.category, version);
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public String getTag() {
        return this.tag;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.convertToString(true, false);
    }

    public String convertToString(boolean showCategory, boolean showDefaultSource) {
        StringBuilder sb = new StringBuilder();
        if (showCategory) {
            sb.append(this.category).append(":");
        }
        if (showDefaultSource || !SingleCategoryTag.isDefaultSourceForCategory(this.category, this.source)) {
            String sourceStr = this.source != null && !this.source.isEmpty() ? this.source + "/" : "";
            sb.append(sourceStr);
        }
        sb.append(this.tag).append("(").append(this.version).append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SingleCategoryTag) {
            SingleCategoryTag t = (SingleCategoryTag)obj;
            if (t.tag.equals(this.tag) && t.category.equals(this.category)) {
                if (this.source == null) {
                    return t.source == null;
                }
                return this.source.equals(t.source);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode() + (this.source != null ? 23 * this.source.hashCode() : 0) + 154 * this.category.hashCode();
    }

    public static void resetDefaultSources() {
        defaultForAllCategories = "<description>";
        defaultCategorySources.clear();
    }

    public static void setDefaultForAllCategories(String defaultForAllCats) {
        defaultForAllCategories = defaultForAllCats;
    }

    public static void setDefaultForCategory(String category, String defaultForCat) {
        defaultCategorySources.put(category, defaultForCat);
    }

    public static boolean hasDefaultSourceForCategory(String category) {
        return defaultCategorySources.containsKey(category);
    }

    public static String getDefaultSourceForCategory(String category) {
        String defCat = defaultForAllCategories;
        String catSpecificDef = defaultCategorySources.computeIfAbsent(category, cat -> SubstitutionTokenUtils.resolveSubstitutionTokens((String)defCat));
        return catSpecificDef;
    }

    public static boolean isDefaultSourceForCategory(String category, String source) {
        return SingleCategoryTag.getDefaultSourceForCategory(category).equals(source);
    }
}

