package org.lsst.ccs.bus.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 * Infrastructure level Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum InfrastructureAlert {

    
    
    /**
     * Alert raised when a periodic task falls behind.
     */
    PERIODIC_TASK_BEHIND("PeriodicTaskBehind","Alert raised when a periodic task falls behind."),
    /**
     * Alert raised when a periodic task raises an exception.
     */
    PERIODIC_TASK_FAILURE("PeriodicTaskFailure","Alert raised when periodic tasks have failures (exceptions) during execution. At ALARM level the task execution is terminated."),
    /**
     * Alert raised when a periodic task has a skipped execution.
     */
    PERIODIC_TASK_SKIPPED("PeriodicTaskSkipped","Alert raised when periodic task executions are skipped."),
    /**
     * Alert raised a state mismatch has been detected.
     */
    STATE_MISMATCH("StateMismatch","Alert raised when the internal state is inconsistent with the actual state"),
    /**
     * Alert raised when a command to publish a state message has been issued.
     */
    REQUESTED_STATE_PUBLICATION("RequestedStatePublication","Alert raised when a command request to publish a state message has been issued.");
    
    
    private final String id, description;
    
    InfrastructureAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id,description);
    }
    
}
